/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.fielddata;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.opensearch.common.FieldMemoryStats;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.CounterMetric;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.util.CollectionUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.FieldDataStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldDataCache;

@PublicApi(since="1.0.0")
public class ShardFieldData
implements IndexFieldDataCache.Listener {
    private final CounterMetric evictionsMetric = new CounterMetric();
    private final CounterMetric totalMetric = new CounterMetric();
    private final ConcurrentMap<String, CounterMetric> perFieldTotals = ConcurrentCollections.newConcurrentMap();

    public FieldDataStats stats(String ... fields) {
        HashMap<String, Long> fieldTotals = null;
        if (!CollectionUtils.isEmpty(fields)) {
            fieldTotals = new HashMap<String, Long>();
            for (Map.Entry entry : this.perFieldTotals.entrySet()) {
                if (!Regex.simpleMatch(fields, (String)entry.getKey())) continue;
                fieldTotals.put((String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
            }
        }
        return new FieldDataStats(this.totalMetric.count(), this.evictionsMetric.count(), fieldTotals == null ? null : new FieldMemoryStats(fieldTotals));
    }

    @Override
    public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
        this.totalMetric.inc(ramUsage.ramBytesUsed());
        CounterMetric total = (CounterMetric)this.perFieldTotals.get(fieldName);
        if (total != null) {
            total.inc(ramUsage.ramBytesUsed());
        } else {
            total = new CounterMetric();
            total.inc(ramUsage.ramBytesUsed());
            CounterMetric prev = this.perFieldTotals.putIfAbsent(fieldName, total);
            if (prev != null) {
                prev.inc(ramUsage.ramBytesUsed());
            }
        }
    }

    @Override
    public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
        if (wasEvicted) {
            this.evictionsMetric.inc();
        }
        if (sizeInBytes != -1L) {
            this.totalMetric.dec(sizeInBytes);
            CounterMetric total = (CounterMetric)this.perFieldTotals.get(fieldName);
            if (total != null) {
                total.dec(sizeInBytes);
            }
        }
    }
}

