/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.Field;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapping;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SeqNoFieldMapper;

@PublicApi(since="1.0.0")
public class ParsedDocument {
    private final Field version;
    private final String id;
    private final SeqNoFieldMapper.SequenceIDFields seqID;
    private final String routing;
    private final List<ParseContext.Document> documents;
    private BytesReference source;
    private MediaType mediaType;
    private Mapping dynamicMappingsUpdate;

    public ParsedDocument(Field version, SeqNoFieldMapper.SequenceIDFields seqID, String id, String routing, List<ParseContext.Document> documents, BytesReference source, MediaType mediaType, Mapping dynamicMappingsUpdate) {
        this.version = version;
        this.seqID = seqID;
        this.id = id;
        this.routing = routing;
        this.documents = documents;
        this.source = source;
        this.dynamicMappingsUpdate = dynamicMappingsUpdate;
        this.mediaType = mediaType;
    }

    public String id() {
        return this.id;
    }

    public Field version() {
        return this.version;
    }

    public void updateSeqID(long sequenceNumber, long primaryTerm) {
        this.seqID.seqNo.setLongValue(sequenceNumber);
        this.seqID.seqNoDocValue.setLongValue(sequenceNumber);
        this.seqID.primaryTerm.setLongValue(primaryTerm);
    }

    ParsedDocument toTombstone() {
        assert (this.docs().size() == 1) : "Tombstone should have a single doc [" + String.valueOf(this.docs()) + "]";
        this.seqID.tombstoneField.setLongValue(1L);
        this.rootDoc().add(this.seqID.tombstoneField);
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public ParseContext.Document rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<ParseContext.Document> docs() {
        return this.documents;
    }

    public BytesReference source() {
        return this.source;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.mediaType = xContentType;
    }

    public Mapping dynamicMappingsUpdate() {
        return this.dynamicMappingsUpdate;
    }

    public void addDynamicMappingsUpdate(Mapping update) {
        this.dynamicMappingsUpdate = this.dynamicMappingsUpdate == null ? update : this.dynamicMappingsUpdate.merge(update, MapperService.MergeReason.MAPPING_UPDATE);
    }

    public String toString() {
        return "Document id[" + this.id + "] doc [" + String.valueOf(this.documents) + "]";
    }
}

