/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public enum IntervalMode implements Writeable
{
    ORDERED(0),
    UNORDERED(1),
    UNORDERED_NO_OVERLAP(2);

    private final int ordinal;

    private IntervalMode(int ordinal) {
        this.ordinal = ordinal;
    }

    public static IntervalMode readFromStream(StreamInput in) throws IOException {
        int ord = in.readVInt();
        switch (ord) {
            case 0: {
                return ORDERED;
            }
            case 1: {
                return UNORDERED;
            }
            case 2: {
                return UNORDERED_NO_OVERLAP;
            }
        }
        throw new OpenSearchException("unknown serialized type [" + ord + "]", new Object[0]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal);
    }

    public static IntervalMode fromString(String intervalMode) {
        if (intervalMode == null) {
            throw new IllegalArgumentException("cannot parse mode from null string");
        }
        for (IntervalMode mode : IntervalMode.values()) {
            if (!mode.name().equalsIgnoreCase(intervalMode)) continue;
            return mode;
        }
        throw new IllegalArgumentException("no mode can be parsed from ordinal " + intervalMode);
    }
}

