/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.memory.MemoryIndex;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.LeafSearchLookup;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public class SourceFieldMatchQuery
extends Query {
    private final Query delegateQuery;
    private final Query filter;
    private final SearchLookup lookup;
    private final MappedFieldType fieldType;
    private final SourceValueFetcher valueFetcher;
    private final QueryShardContext context;

    public SourceFieldMatchQuery(Query delegateQuery, Query filter, MappedFieldType fieldType, QueryShardContext context) {
        this.delegateQuery = delegateQuery;
        this.filter = filter;
        this.fieldType = fieldType;
        this.context = context;
        this.lookup = context.lookup();
        if (!context.documentMapper("").sourceMapper().enabled()) {
            throw new IllegalArgumentException("SourceFieldMatchQuery error: unable to fetch fields from _source field: _source is disabled in the mappings for index [" + context.index().getName() + "]");
        }
        this.valueFetcher = (SourceValueFetcher)fieldType.valueFetcher(context, this.lookup, null);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.delegateQuery.visit(visitor);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = indexSearcher.rewrite(this.delegateQuery);
        if (rewritten == this.delegateQuery) {
            return this;
        }
        return new SourceFieldMatchQuery(rewritten, this.filter, this.fieldType, this.context);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight weight = this.delegateQuery.createWeight(searcher, ScoreMode.TOP_DOCS, boost);
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                Scorer scorer = weight.scorer(context);
                if (scorer == null) {
                    return null;
                }
                DocIdSetIterator approximation = scorer.iterator();
                final LeafSearchLookup leafSearchLookup = SourceFieldMatchQuery.this.lookup.getLeafSearchLookup(context);
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() {
                        leafSearchLookup.setDocument(this.approximation.docID());
                        List<Object> values = SourceFieldMatchQuery.this.valueFetcher.fetchValues(leafSearchLookup.source());
                        if (values.isEmpty()) {
                            return false;
                        }
                        MemoryIndex memoryIndex = new MemoryIndex();
                        for (Object value : values) {
                            memoryIndex.addField(SourceFieldMatchQuery.this.fieldType.name(), (String)value, SourceFieldMatchQuery.this.fieldType.indexAnalyzer());
                        }
                        float score = memoryIndex.search(SourceFieldMatchQuery.this.filter);
                        return score > 0.0f;
                    }

                    @Override
                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), ScoreMode.TOP_DOCS, twoPhase);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return weight.isCacheable(ctx);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        SourceFieldMatchQuery other = (SourceFieldMatchQuery)o;
        return Objects.equals(this.delegateQuery, other.delegateQuery) && Objects.equals(this.filter, other.filter) && Objects.equals(this.fieldType, other.fieldType) && Objects.equals(this.context, other.context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.delegateQuery, this.filter, this.fieldType, this.context);
    }

    @Override
    public String toString(String f) {
        return "SourceFieldMatchQuery (delegate query: [ " + this.delegateQuery.toString(f) + " ], filter query: [ " + this.filter.toString(f) + "])";
    }
}

