/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.util.ArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.LatLonDocValuesField;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.LatLonPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexOrDocValuesQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoPolygonDecomposer;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoShapeType;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoShapeUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.ShapeRelation;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Circle;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Geometry;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.GeometryCollection;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.GeometryVisitor;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Line;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.LinearRing;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiLine;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiPoint;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiPolygon;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Point;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Polygon;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Rectangle;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.ShapeType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.GeoPointFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;

public class VectorGeoPointShapeQueryProcessor {
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        this.validateIsGeoPointFieldType(fieldName, context);
        if (relation != ShapeRelation.INTERSECTS) {
            throw new QueryShardException(context, String.valueOf(relation) + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private void validateIsGeoPointFieldType(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context, "Expected geo_point field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }

    protected Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        ShapeVisitor shapeVisitor = new ShapeVisitor(context, fieldName, relation);
        return queryShape.visit(shapeVisitor);
    }

    private class ShapeVisitor
    implements GeometryVisitor<Query, RuntimeException> {
        QueryShardContext context;
        MappedFieldType fieldType;
        String fieldName;
        ShapeRelation relation;

        ShapeVisitor(QueryShardContext context, String fieldName, ShapeRelation relation) {
            this.context = context;
            this.fieldType = context.fieldMapper(fieldName);
            this.fieldName = fieldName;
            this.relation = relation;
        }

        @Override
        public Query visit(Circle circle) {
            Query query = LatLonPoint.newDistanceQuery(this.fieldName, circle.getLat(), circle.getLon(), circle.getRadiusMeters());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowDistanceQuery(this.fieldName, circle.getLat(), circle.getLon(), circle.getRadiusMeters());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        @Override
        public Query visit(GeometryCollection<?> collection) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            this.visit(bqb, collection);
            return bqb.build();
        }

        private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
            BooleanClause.Occur occur = BooleanClause.Occur.FILTER;
            for (Geometry shape : collection) {
                bqb.add(shape.visit(this), occur);
            }
        }

        @Override
        public Query visit(Line line) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)GeoShapeType.LINESTRING) + " queries", new Object[0]);
        }

        @Override
        public Query visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)ShapeType.LINEARRING) + " queries", new Object[0]);
        }

        @Override
        public Query visit(MultiLine multiLine) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)GeoShapeType.MULTILINESTRING) + " queries", new Object[0]);
        }

        @Override
        public Query visit(MultiPoint multiPoint) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)GeoShapeType.MULTIPOINT) + " queries", new Object[0]);
        }

        @Override
        private Query visit(ArrayList<Polygon> collector) {
            org.graylog.shaded.opensearch2.org.apache.lucene.geo.Polygon[] lucenePolygons = new org.graylog.shaded.opensearch2.org.apache.lucene.geo.Polygon[collector.size()];
            for (int i = 0; i < collector.size(); ++i) {
                lucenePolygons[i] = GeoShapeUtils.toLucenePolygon(collector.get(i));
            }
            Query query = LatLonPoint.newPolygonQuery(this.fieldName, lucenePolygons);
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowPolygonQuery(this.fieldName, lucenePolygons);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        @Override
        public Query visit(MultiPolygon multiPolygon) {
            ArrayList<Polygon> collector = new ArrayList<Polygon>();
            GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, true, collector);
            return this.visit(collector);
        }

        @Override
        public Query visit(Point point) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + String.valueOf((Object)GeoShapeType.POINT) + " queries", new Object[0]);
        }

        @Override
        public Query visit(Polygon polygon) {
            ArrayList<Polygon> collector = new ArrayList<Polygon>();
            GeoPolygonDecomposer.decomposePolygon(polygon, true, collector);
            return this.visit(collector);
        }

        @Override
        public Query visit(Rectangle r) {
            Query query = LatLonPoint.newBoxQuery(this.fieldName, r.getMinY(), r.getMaxY(), r.getMinX(), r.getMaxX());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowBoxQuery(this.fieldName, r.getMinY(), r.getMaxY(), r.getMinX(), r.getMaxX());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }
    }
}

