/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.seqno;

import java.io.IOException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.TransportReplicationAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.action.shard.ShardStateAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class GlobalCheckpointSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static String ACTION_NAME = "indices:admin/seq_no/global_checkpoint_sync";

    @Inject
    public GlobalCheckpointSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, x$0 -> new Request(x$0), x$0 -> new Request(x$0), "management");
    }

    public void updateGlobalCheckpointForShard(ShardId shardId) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            this.execute(new Request(shardId), ActionListener.wrap(r -> {}, e -> {
                if (ExceptionsHelper.unwrap(e, AlreadyClosedException.class, IndexShardClosedException.class) == null) {
                    this.logger.info((Message)new ParameterizedMessage("{} global checkpoint sync failed", (Object)shardId), (Throwable)e);
                }
            }));
        }
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard indexShard, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            this.maybeSyncTranslog(indexShard);
            return new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse());
        });
    }

    @Override
    protected void shardOperationOnReplica(Request shardRequest, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            this.maybeSyncTranslog(replica);
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    private void maybeSyncTranslog(IndexShard indexShard) throws IOException {
        if (indexShard.getTranslogDurability() == Translog.Durability.REQUEST && indexShard.getLastSyncedGlobalCheckpoint() < indexShard.getLastKnownGlobalCheckpoint() && !indexShard.isRemoteTranslogEnabled()) {
            indexShard.sync();
        }
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(ShardId shardId) {
            super(shardId);
        }

        @Override
        public String toString() {
            return "GlobalCheckpointSyncAction.Request{shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", index='" + this.index + "', waitForActiveShards=" + String.valueOf(this.waitForActiveShards) + "}";
        }
    }
}

