/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexCommit;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FilterDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Lock;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.NoLockFactory;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.concurrent.GatedCloseable;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.Index;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;

final class LocalShardSnapshot
implements Closeable {
    private final IndexShard shard;
    private final Store store;
    private final GatedCloseable<IndexCommit> wrappedIndexCommit;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    LocalShardSnapshot(IndexShard shard) {
        this.shard = shard;
        this.store = shard.store();
        this.store.incRef();
        boolean success = false;
        try {
            this.wrappedIndexCommit = shard.acquireLastIndexCommit(true);
            success = true;
        }
        finally {
            if (!success) {
                this.store.decRef();
            }
        }
    }

    Index getIndex() {
        return this.shard.indexSettings().getIndex();
    }

    long maxSeqNo() {
        return this.shard.getEngine().getSeqNoStats(-1L).getMaxSeqNo();
    }

    long maxUnsafeAutoIdTimestamp() {
        return Long.parseLong(this.shard.getEngine().commitStats().getUserData().get("max_unsafe_auto_id_timestamp"));
    }

    Directory getSnapshotDirectory() {
        return new FilterDirectory(this.store.directory()){

            @Override
            public String[] listAll() throws IOException {
                Collection<String> fileNames = LocalShardSnapshot.this.wrappedIndexCommit.get().getFileNames();
                String[] fileNameArray = fileNames.toArray(new String[fileNames.size()]);
                return fileNameArray;
            }

            @Override
            public void deleteFile(String name) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public void sync(Collection<String> names) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public void rename(String source, String dest) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public Lock obtainLock(String name) throws IOException {
                return NoLockFactory.INSTANCE.obtainLock(this.in, name);
            }

            @Override
            public void close() throws IOException {
                throw new UnsupportedOperationException("nobody should close this directory wrapper");
            }

            @Override
            public Set<String> getPendingDeletions() throws IOException {
                return this.in.getPendingDeletions();
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.wrappedIndexCommit.close();
            }
            finally {
                this.store.decRef();
            }
        }
    }

    IndexMetadata getIndexMetadata() {
        return this.shard.indexSettings.getIndexMetadata();
    }

    public String toString() {
        return "local_shard_snapshot:[" + String.valueOf(this.shard.shardId()) + " indexCommit: " + String.valueOf(this.wrappedIndexCommit) + "]";
    }
}

