/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ReferenceManager;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.MeanMetric;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.RunOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;

public final class RefreshListeners
implements ReferenceManager.RefreshListener,
Closeable {
    private final IntSupplier getMaxRefreshListeners;
    private final Runnable forceRefresh;
    private final Logger logger;
    private final ThreadContext threadContext;
    private final MeanMetric refreshMetric;
    private long currentRefreshStartTime;
    private volatile boolean closed = false;
    private int refreshForcers;
    private volatile List<Tuple<Translog.Location, Consumer<Boolean>>> refreshListeners = null;
    private volatile Translog.Location lastRefreshedLocation;
    private Translog.Location currentRefreshLocation;
    private Supplier<Translog.Location> currentRefreshLocationSupplier;

    public RefreshListeners(IntSupplier getMaxRefreshListeners, Runnable forceRefresh, Logger logger, ThreadContext threadContext, MeanMetric refreshMetric) {
        this.getMaxRefreshListeners = getMaxRefreshListeners;
        this.forceRefresh = forceRefresh;
        this.logger = logger;
        this.threadContext = threadContext;
        this.refreshMetric = refreshMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Releasable forceRefreshes() {
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            assert (this.refreshForcers >= 0);
            ++this.refreshForcers;
        }
        RunOnce runOnce = new RunOnce(() -> {
            RefreshListeners refreshListeners = this;
            synchronized (refreshListeners) {
                assert (this.refreshForcers > 0);
                --this.refreshForcers;
            }
        });
        if (this.refreshNeeded()) {
            try {
                this.forceRefresh.run();
            }
            catch (Exception e) {
                runOnce.run();
                throw e;
            }
        }
        assert (this.refreshListeners == null);
        return () -> runOnce.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrNotify(Translog.Location location, Consumer<Boolean> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(location, "location cannot be null");
        if (this.lastRefreshedLocation != null && this.lastRefreshedLocation.compareTo(location) >= 0) {
            listener.accept(false);
            return true;
        }
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            if (this.closed) {
                throw new IllegalStateException("can't wait for refresh on a closed index");
            }
            List<Tuple<Translog.Location, Consumer<Boolean>>> listeners = this.refreshListeners;
            int maxRefreshes = this.getMaxRefreshListeners.getAsInt();
            if (this.refreshForcers == 0 && maxRefreshes > 0 && (listeners == null || listeners.size() < maxRefreshes)) {
                ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext(true);
                Consumer<Boolean> contextPreservingListener = forced -> {
                    try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
                        storedContext.restore();
                        listener.accept((Boolean)forced);
                    }
                };
                if (listeners == null) {
                    listeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
                }
                listeners.add(new Tuple<Translog.Location, Consumer<Boolean>>(location, contextPreservingListener));
                this.refreshListeners = listeners;
                return false;
            }
        }
        this.forceRefresh.run();
        listener.accept(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        List<Tuple<Translog.Location, Consumer<Boolean>>> oldListeners;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            oldListeners = this.refreshListeners;
            this.refreshListeners = null;
            this.closed = true;
        }
        this.fireListeners(oldListeners);
    }

    public boolean refreshNeeded() {
        return this.refreshListeners != null && false == this.closed;
    }

    public int pendingCount() {
        List<Tuple<Translog.Location, Consumer<Boolean>>> listeners = this.refreshListeners;
        return listeners == null ? 0 : listeners.size();
    }

    public void setCurrentRefreshLocationSupplier(Supplier<Translog.Location> currentRefreshLocationSupplier) {
        this.currentRefreshLocationSupplier = currentRefreshLocationSupplier;
    }

    @Override
    public void beforeRefresh() throws IOException {
        this.currentRefreshLocation = this.currentRefreshLocationSupplier.get();
        this.currentRefreshStartTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRefresh(boolean didRefresh) throws IOException {
        List<Tuple<Translog.Location, Consumer<Boolean>>> candidates;
        this.refreshMetric.inc(System.nanoTime() - this.currentRefreshStartTime);
        if (null == this.currentRefreshLocation) {
            return;
        }
        this.lastRefreshedLocation = this.currentRefreshLocation;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            candidates = this.refreshListeners;
            if (candidates == null) {
                return;
            }
            this.refreshListeners = null;
        }
        ArrayList<Tuple<Translog.Location, Consumer<Boolean>>> listenersToFire = null;
        ArrayList<Tuple<Translog.Location, Consumer<Boolean>>> preservedListeners = null;
        for (Tuple<Translog.Location, Consumer<Boolean>> tuple : candidates) {
            Translog.Location location = tuple.v1();
            if (location.compareTo(this.currentRefreshLocation) <= 0) {
                if (listenersToFire == null) {
                    listenersToFire = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
                }
                listenersToFire.add(tuple);
                continue;
            }
            if (preservedListeners == null) {
                preservedListeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
            }
            preservedListeners.add(tuple);
        }
        if (preservedListeners != null) {
            RefreshListeners refreshListeners2 = this;
            synchronized (refreshListeners2) {
                if (this.refreshListeners == null) {
                    if (this.closed) {
                        listenersToFire.addAll(preservedListeners);
                    } else {
                        this.refreshListeners = preservedListeners;
                    }
                } else {
                    assert (!this.closed) : "Can't be closed and have non-null refreshListeners";
                    this.refreshListeners.addAll(preservedListeners);
                }
            }
        }
        this.fireListeners(listenersToFire);
    }

    private void fireListeners(List<Tuple<Translog.Location, Consumer<Boolean>>> listenersToFire) {
        if (listenersToFire != null) {
            for (Tuple<Translog.Location, Consumer<Boolean>> listener : listenersToFire) {
                try {
                    listener.v2().accept(false);
                }
                catch (Exception e) {
                    this.logger.warn("error firing refresh listener", (Throwable)e);
                }
            }
        }
    }
}

