/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import java.io.IOException;
import java.io.PrintStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CheckIndex;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Lock;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.RemoveCorruptedShardDataCommand;

public class RemoveCorruptedLuceneSegmentsAction {
    public Tuple<RemoveCorruptedShardDataCommand.CleanStatus, String> getCleanStatus(Directory indexDirectory, Lock writeLock, PrintStream printStream, boolean verbose) throws IOException {
        boolean markedCorrupted = RemoveCorruptedShardDataCommand.isCorruptMarkerFileIsPresent(indexDirectory);
        try (CheckIndex checker = new CheckIndex(indexDirectory, writeLock);){
            checker.setChecksumsOnly(true);
            checker.setInfoStream(printStream, verbose);
            CheckIndex.Status status = checker.checkIndex(null);
            if (status.missingSegments) {
                Tuple<RemoveCorruptedShardDataCommand.CleanStatus, String> tuple = Tuple.tuple(RemoveCorruptedShardDataCommand.CleanStatus.UNRECOVERABLE, "Index is unrecoverable - there are missing segments");
                return tuple;
            }
            Tuple<RemoveCorruptedShardDataCommand.CleanStatus, Object> tuple = status.clean ? Tuple.tuple(markedCorrupted ? RemoveCorruptedShardDataCommand.CleanStatus.CLEAN_WITH_CORRUPTED_MARKER : RemoveCorruptedShardDataCommand.CleanStatus.CLEAN, null) : Tuple.tuple(RemoveCorruptedShardDataCommand.CleanStatus.CORRUPTED, "Corrupted Lucene index segments found - " + status.totLoseDocCount + " documents will be lost.");
            return tuple;
        }
    }

    public void execute(Terminal terminal, Directory indexDirectory, Lock writeLock, PrintStream printStream, boolean verbose) throws IOException {
        block7: {
            try (CheckIndex checker = new CheckIndex(indexDirectory, writeLock);){
                checker.setChecksumsOnly(true);
                checker.setInfoStream(printStream, verbose);
                CheckIndex.Status status = checker.checkIndex(null);
                if (!status.missingSegments) {
                    if (!status.clean) {
                        terminal.println("Writing...");
                        checker.exorciseIndex(status);
                        terminal.println("OK");
                        terminal.println("Wrote new segments file \"" + status.segmentsFileName + "\"");
                    }
                    break block7;
                }
                throw new OpenSearchException("Index is unrecoverable - there are missing segments", new Object[0]);
            }
        }
    }
}

