/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.AllocationId;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.CorruptStateException;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.MetadataStateFormat;

public final class ShardStateMetadata {
    private static final String SHARD_STATE_FILE_PREFIX = "state-";
    private static final String PRIMARY_KEY = "primary";
    private static final String INDEX_UUID_KEY = "index_uuid";
    private static final String ALLOCATION_ID_KEY = "allocation_id";
    private static final String INDEX_DATA_LOCATION_KEY = "index_data_location";
    public final String indexUUID;
    public final boolean primary;
    @Nullable
    public final AllocationId allocationId;
    public final IndexDataLocation indexDataLocation;
    public static final MetadataStateFormat<ShardStateMetadata> FORMAT = new MetadataStateFormat<ShardStateMetadata>("state-"){

        @Override
        protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
            XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
            xContentBuilder.prettyPrint();
            return xContentBuilder;
        }

        @Override
        public void toXContent(XContentBuilder builder, ShardStateMetadata shardStateMetadata) throws IOException {
            builder.field(ShardStateMetadata.PRIMARY_KEY, shardStateMetadata.primary);
            builder.field(ShardStateMetadata.INDEX_UUID_KEY, shardStateMetadata.indexUUID);
            if (shardStateMetadata.allocationId != null) {
                builder.field(ShardStateMetadata.ALLOCATION_ID_KEY, shardStateMetadata.allocationId);
            }
            if (shardStateMetadata.indexDataLocation != IndexDataLocation.LOCAL) {
                builder.field(ShardStateMetadata.INDEX_DATA_LOCATION_KEY, (Object)shardStateMetadata.indexDataLocation);
            }
        }

        @Override
        public ShardStateMetadata fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return null;
            }
            Boolean primary = null;
            String currentFieldName = null;
            String indexUUID = "_na_";
            AllocationId allocationId = null;
            IndexDataLocation indexDataLocation = IndexDataLocation.LOCAL;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (ShardStateMetadata.PRIMARY_KEY.equals(currentFieldName)) {
                        primary = parser.booleanValue();
                        continue;
                    }
                    if (ShardStateMetadata.INDEX_UUID_KEY.equals(currentFieldName)) {
                        indexUUID = parser.text();
                        continue;
                    }
                    if (ShardStateMetadata.INDEX_DATA_LOCATION_KEY.equals(currentFieldName)) {
                        String stringValue = parser.text();
                        try {
                            indexDataLocation = IndexDataLocation.valueOf(stringValue);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw new CorruptStateException("unexpected value for data location [" + stringValue + "]");
                        }
                    }
                    throw new CorruptStateException("unexpected field in shard state [" + currentFieldName + "]");
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (ShardStateMetadata.ALLOCATION_ID_KEY.equals(currentFieldName)) {
                        allocationId = AllocationId.fromXContent(parser);
                        continue;
                    }
                    throw new CorruptStateException("unexpected object in shard state [" + currentFieldName + "]");
                }
                throw new CorruptStateException("unexpected token in shard state [" + token.name() + "]");
            }
            if (primary == null) {
                throw new CorruptStateException("missing value for [primary] in shard state");
            }
            return new ShardStateMetadata(primary, indexUUID, allocationId, indexDataLocation);
        }
    };

    public ShardStateMetadata(boolean primary, String indexUUID, AllocationId allocationId) {
        this(primary, indexUUID, allocationId, IndexDataLocation.LOCAL);
    }

    public ShardStateMetadata(boolean primary, String indexUUID, AllocationId allocationId, IndexDataLocation indexDataLocation) {
        assert (indexUUID != null);
        this.primary = primary;
        this.indexUUID = indexUUID;
        this.allocationId = allocationId;
        this.indexDataLocation = Objects.requireNonNull(indexDataLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStateMetadata that = (ShardStateMetadata)o;
        if (this.primary != that.primary) {
            return false;
        }
        if (!this.indexUUID.equals(that.indexUUID)) {
            return false;
        }
        if (!Objects.equals(this.allocationId, that.allocationId)) {
            return false;
        }
        return Objects.equals((Object)this.indexDataLocation, (Object)that.indexDataLocation);
    }

    public int hashCode() {
        int result = this.indexUUID.hashCode();
        result = 31 * result + (this.allocationId != null ? this.allocationId.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        result = 31 * result + this.indexDataLocation.hashCode();
        return result;
    }

    public String toString() {
        return "primary [" + this.primary + "], allocation [" + String.valueOf(this.allocationId) + "], index data location [" + String.valueOf((Object)this.indexDataLocation) + "]";
    }

    public static enum IndexDataLocation {
        LOCAL,
        REMOTE;

    }
}

