/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.RemoteFsTranslog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogDeletionPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogFactory;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteBlobStoreInternalTranslogFactory
implements TranslogFactory {
    private final Repository repository;
    private final ThreadPool threadPool;
    private final RemoteTranslogTransferTracker remoteTranslogTransferTracker;

    public RemoteBlobStoreInternalTranslogFactory(Supplier<RepositoriesService> repositoriesServiceSupplier, ThreadPool threadPool, String repositoryName, RemoteTranslogTransferTracker remoteTranslogTransferTracker) {
        Repository repository;
        try {
            repository = repositoriesServiceSupplier.get().repository(repositoryName);
        }
        catch (RepositoryMissingException ex) {
            throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", ex);
        }
        this.repository = repository;
        this.threadPool = threadPool;
        this.remoteTranslogTransferTracker = remoteTranslogTransferTracker;
    }

    @Override
    public Translog newTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, BooleanSupplier startedPrimarySupplier) throws IOException {
        assert (this.repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)this.repository;
        return new RemoteFsTranslog(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer, blobStoreRepository, this.threadPool, startedPrimarySupplier, this.remoteTranslogTransferTracker);
    }

    public Repository getRepository() {
        return this.repository;
    }
}

