/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogException;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.listener.TranslogEventListener;

public final class CompositeTranslogEventListener
implements TranslogEventListener {
    private final List<TranslogEventListener> listeners;
    private final ShardId shardId;
    private final Logger logger = LogManager.getLogger(CompositeTranslogEventListener.class);

    public CompositeTranslogEventListener(Collection<TranslogEventListener> listeners, ShardId shardId) {
        this.shardId = shardId;
        for (TranslogEventListener listener : listeners) {
            if (listener != null) continue;
            throw new IllegalArgumentException("listeners must be non-null");
        }
        this.listeners = Collections.unmodifiableList(new ArrayList<TranslogEventListener>(listeners));
    }

    @Override
    public void onAfterTranslogSync() {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>(this.listeners.size());
        for (TranslogEventListener listener : this.listeners) {
            try {
                listener.onAfterTranslogSync();
            }
            catch (Exception ex) {
                this.logger.warn(() -> new ParameterizedMessage("failed to invoke onTranslogSync listener", new Object[0]), (Throwable)ex);
                exceptionList.add(ex);
            }
        }
        this.maybeThrowTranslogExceptionAndSuppress(exceptionList);
    }

    @Override
    public void onAfterTranslogRecovery() {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>(this.listeners.size());
        for (TranslogEventListener listener : this.listeners) {
            try {
                listener.onAfterTranslogRecovery();
            }
            catch (Exception ex) {
                this.logger.warn(() -> new ParameterizedMessage("failed to invoke onTranslogRecovery listener", new Object[0]), (Throwable)ex);
                exceptionList.add(ex);
            }
        }
        this.maybeThrowTranslogExceptionAndSuppress(exceptionList);
    }

    @Override
    public void onBeginTranslogRecovery() {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>(this.listeners.size());
        for (TranslogEventListener listener : this.listeners) {
            try {
                listener.onBeginTranslogRecovery();
            }
            catch (Exception ex) {
                this.logger.warn(() -> new ParameterizedMessage("failed to invoke onBeginTranslogRecovery listener", new Object[0]), (Throwable)ex);
                exceptionList.add(ex);
            }
        }
        this.maybeThrowTranslogExceptionAndSuppress(exceptionList);
    }

    @Override
    public void onFailure(String reason, Exception e) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>(this.listeners.size());
        for (TranslogEventListener listener : this.listeners) {
            try {
                listener.onFailure(reason, e);
            }
            catch (Exception ex) {
                this.logger.warn(() -> new ParameterizedMessage("failed to invoke onFailure listener", new Object[0]), (Throwable)ex);
                exceptionList.add(ex);
            }
        }
        this.maybeThrowTranslogExceptionAndSuppress(exceptionList);
    }

    private <T extends Throwable> void maybeThrowTranslogExceptionAndSuppress(List<T> exceptions) {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw new TranslogException(this.shardId, "Error while executing translog event listener", main);
        }
    }
}

