/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public class TermsLookup
implements Writeable,
ToXContentFragment {
    private final String index;
    private final String id;
    private final String path;
    private String routing;
    private static final ConstructingObjectParser<TermsLookup, Void> PARSER = new ConstructingObjectParser("terms_lookup", args -> {
        String index = (String)args[0];
        String id = (String)args[1];
        String path = (String)args[2];
        return new TermsLookup(index, id, path);
    });

    public TermsLookup(String index, String id, String path) {
        if (id == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the id.");
        }
        if (path == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the path.");
        }
        if (index == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the index.");
        }
        this.index = index;
        this.id = id;
        this.path = path;
    }

    public TermsLookup(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_2_0_0)) {
            in.readOptionalString();
        }
        this.id = in.readString();
        this.path = in.readString();
        this.index = in.readString();
        this.routing = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeOptionalString("_doc");
        }
        out.writeString(this.id);
        out.writeString(this.path);
        out.writeString(this.index);
        out.writeOptionalString(this.routing);
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    public String path() {
        return this.path;
    }

    public String routing() {
        return this.routing;
    }

    public TermsLookup routing(String routing) {
        this.routing = routing;
        return this;
    }

    public static TermsLookup parseTermsLookup(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public String toString() {
        return this.index + "/" + this.id + "/" + this.path;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("index", this.index);
        builder.field("id", this.id);
        builder.field("path", this.path);
        if (this.routing != null) {
            builder.field("routing", this.routing);
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.id, this.path, this.routing);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermsLookup other = (TermsLookup)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.id, other.id) && Objects.equals(this.path, other.path) && Objects.equals(this.routing, other.routing);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("path", new String[0]));
        PARSER.declareString(TermsLookup::routing, new ParseField("routing", new String[0]));
    }
}

