/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node;

import java.io.IOException;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;

public class NodeResourceUsageStats
implements Writeable {
    final String nodeId;
    long timestamp;
    double cpuUtilizationPercent;
    double memoryUtilizationPercent;

    public NodeResourceUsageStats(String nodeId, long timestamp, double memoryUtilizationPercent, double cpuUtilizationPercent) {
        this.nodeId = nodeId;
        this.timestamp = timestamp;
        this.cpuUtilizationPercent = cpuUtilizationPercent;
        this.memoryUtilizationPercent = memoryUtilizationPercent;
    }

    public NodeResourceUsageStats(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.timestamp = in.readLong();
        this.cpuUtilizationPercent = in.readDouble();
        this.memoryUtilizationPercent = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeLong(this.timestamp);
        out.writeDouble(this.cpuUtilizationPercent);
        out.writeDouble(this.memoryUtilizationPercent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NodeResourceUsageStats[");
        sb.append(this.nodeId).append("](");
        sb.append("Timestamp: ").append(this.timestamp);
        sb.append(", CPU utilization percent: ").append(String.format(Locale.ROOT, "%.1f", this.cpuUtilizationPercent));
        sb.append(", Memory utilization percent: ").append(String.format(Locale.ROOT, "%.1f", this.memoryUtilizationPercent));
        sb.append(")");
        return sb.toString();
    }

    NodeResourceUsageStats(NodeResourceUsageStats nodeResourceUsageStats) {
        this(nodeResourceUsageStats.nodeId, nodeResourceUsageStats.timestamp, nodeResourceUsageStats.memoryUtilizationPercent, nodeResourceUsageStats.cpuUtilizationPercent);
    }

    public double getMemoryUtilizationPercent() {
        return this.memoryUtilizationPercent;
    }

    public double getCpuUtilizationPercent() {
        return this.cpuUtilizationPercent;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

