/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker;

import org.graylog.shaded.opensearch2.org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker.AverageCpuUsageTracker;
import org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker.AverageMemoryUsageTracker;
import org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker.ResourceTrackerSettings;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class NodeResourceUsageTracker
extends AbstractLifecycleComponent {
    private ThreadPool threadPool;
    private final ClusterSettings clusterSettings;
    private AverageCpuUsageTracker cpuUsageTracker;
    private AverageMemoryUsageTracker memoryUsageTracker;
    private ResourceTrackerSettings resourceTrackerSettings;

    public NodeResourceUsageTracker(ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        this.threadPool = threadPool;
        this.clusterSettings = clusterSettings;
        this.resourceTrackerSettings = new ResourceTrackerSettings(settings);
        this.initialize();
    }

    public double getCpuUtilizationPercent() {
        if (this.cpuUsageTracker.isReady()) {
            return this.cpuUsageTracker.getAverage();
        }
        return 0.0;
    }

    public double getMemoryUtilizationPercent() {
        if (this.memoryUsageTracker.isReady()) {
            return this.memoryUsageTracker.getAverage();
        }
        return 0.0;
    }

    public boolean isReady() {
        return this.memoryUsageTracker.isReady() && this.cpuUsageTracker.isReady();
    }

    void initialize() {
        this.cpuUsageTracker = new AverageCpuUsageTracker(this.threadPool, this.resourceTrackerSettings.getCpuPollingInterval(), this.resourceTrackerSettings.getCpuWindowDuration());
        this.clusterSettings.addSettingsUpdateConsumer(ResourceTrackerSettings.GLOBAL_CPU_USAGE_AC_WINDOW_DURATION_SETTING, this::setCpuWindowDuration);
        this.memoryUsageTracker = new AverageMemoryUsageTracker(this.threadPool, this.resourceTrackerSettings.getMemoryPollingInterval(), this.resourceTrackerSettings.getMemoryWindowDuration());
        this.clusterSettings.addSettingsUpdateConsumer(ResourceTrackerSettings.GLOBAL_JVM_USAGE_AC_WINDOW_DURATION_SETTING, this::setMemoryWindowDuration);
    }

    private void setMemoryWindowDuration(TimeValue windowDuration) {
        this.memoryUsageTracker.setWindowSize(windowDuration);
        this.resourceTrackerSettings.setMemoryWindowDuration(windowDuration);
    }

    private void setCpuWindowDuration(TimeValue windowDuration) {
        this.cpuUsageTracker.setWindowSize(windowDuration);
        this.resourceTrackerSettings.setCpuWindowDuration(windowDuration);
    }

    ResourceTrackerSettings getResourceTrackerSettings() {
        return this.resourceTrackerSettings;
    }

    @Override
    protected void doStart() {
        this.cpuUsageTracker.doStart();
        this.memoryUsageTracker.doStart();
    }

    @Override
    protected void doStop() {
        this.cpuUsageTracker.doStop();
        this.memoryUsageTracker.doStop();
    }

    @Override
    protected void doClose() {
        this.cpuUsageTracker.doClose();
        this.memoryUsageTracker.doClose();
    }
}

