/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.controllers;

import java.util.Locale;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeResourceUsageStats;
import org.graylog.shaded.opensearch2.org.opensearch.node.ResourceUsageCollectorService;
import org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.controllers.AdmissionController;
import org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlActionType;
import org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.settings.CpuBasedAdmissionControllerSettings;

public class CpuBasedAdmissionController
extends AdmissionController {
    public static final String CPU_BASED_ADMISSION_CONTROLLER = "global_cpu_usage";
    private static final Logger LOGGER = LogManager.getLogger(CpuBasedAdmissionController.class);
    public CpuBasedAdmissionControllerSettings settings;

    public CpuBasedAdmissionController(String admissionControllerName, ResourceUsageCollectorService resourceUsageCollectorService, ClusterService clusterService, Settings settings) {
        super(admissionControllerName, resourceUsageCollectorService, clusterService);
        this.settings = new CpuBasedAdmissionControllerSettings(clusterService.getClusterSettings(), settings);
    }

    @Override
    public void apply(String action, AdmissionControlActionType admissionControlActionType) {
        if (this.isEnabledForTransportLayer(this.settings.getTransportLayerAdmissionControllerMode())) {
            this.applyForTransportLayer(action, admissionControlActionType);
        }
    }

    private void applyForTransportLayer(String actionName, AdmissionControlActionType admissionControlActionType) {
        if (this.isLimitsBreached(actionName, admissionControlActionType)) {
            this.addRejectionCount(admissionControlActionType.getType(), 1L);
            if (this.isAdmissionControllerEnforced(this.settings.getTransportLayerAdmissionControllerMode()).booleanValue()) {
                throw new OpenSearchRejectedExecutionException(String.format(Locale.ROOT, "CPU usage admission controller rejected the request for action [%s] as CPU limit reached", admissionControlActionType.name()));
            }
        }
    }

    private boolean isLimitsBreached(String actionName, AdmissionControlActionType admissionControlActionType) {
        if (this.clusterService.state() != null && this.clusterService.state().nodes() != null) {
            double cpuUsage;
            long maxCpuLimit = this.getCpuRejectionThreshold(admissionControlActionType);
            Optional<NodeResourceUsageStats> nodePerformanceStatistics = this.resourceUsageCollectorService.getNodeStatistics(this.clusterService.state().nodes().getLocalNodeId());
            if (nodePerformanceStatistics.isPresent() && (cpuUsage = nodePerformanceStatistics.get().getCpuUtilizationPercent()) >= (double)maxCpuLimit) {
                LOGGER.warn("CpuBasedAdmissionController limit reached as the current CPU usage [{}] exceeds the allowed limit [{}] for transport action [{}] in admissionControlMode [{}]", (Object)cpuUsage, (Object)maxCpuLimit, (Object)actionName, (Object)this.settings.getTransportLayerAdmissionControllerMode());
                return true;
            }
        }
        return false;
    }

    private long getCpuRejectionThreshold(AdmissionControlActionType admissionControlActionType) {
        switch (admissionControlActionType) {
            case SEARCH: {
                return this.settings.getSearchCPULimit();
            }
            case INDEXING: {
                return this.settings.getIndexingCPULimit();
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Admission control not Supported for AdmissionControlActionType: %s", admissionControlActionType.getType()));
    }
}

