/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BytesRestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestResponseListener;

public class RestNodesHotThreadsAction
extends BaseRestHandler {
    private static final String formatDeprecatedMessageWithoutNodeID = "[%s] is a deprecated endpoint. Please use [/_nodes/hot_threads] instead.";
    private static final String formatDeprecatedMessageWithNodeID = "[%s] is a deprecated endpoint. Please use [/_nodes/{nodeId}/hot_threads] instead.";
    private static final String DEPRECATED_MESSAGE_CLUSTER_NODES_HOT_THREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/hot_threads] instead.", "/_cluster/nodes/hot_threads");
    private static final String DEPRECATED_MESSAGE_CLUSTER_NODES_NODEID_HOT_THREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/{nodeId}/hot_threads] instead.", "/_cluster/nodes/{nodeId}/hot_threads");
    private static final String DEPRECATED_MESSAGE_CLUSTER_NODES_HOTTHREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/hot_threads] instead.", "/_cluster/nodes/hotthreads");
    private static final String DEPRECATED_MESSAGE_CLUSTER_NODES_NODEID_HOTTHREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/{nodeId}/hot_threads] instead.", "/_cluster/nodes/{nodeId}/hotthreads");
    private static final String DEPRECATED_MESSAGE_NODES_HOTTHREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/hot_threads] instead.", "/_nodes/hotthreads");
    private static final String DEPRECATED_MESSAGE_NODES_NODEID_HOTTHREADS = String.format(Locale.ROOT, "[%s] is a deprecated endpoint. Please use [/_nodes/{nodeId}/hot_threads] instead.", "/_nodes/{nodeId}/hotthreads");

    @Override
    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/_cluster/nodes/hot_threads", DEPRECATED_MESSAGE_CLUSTER_NODES_HOT_THREADS), new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/_cluster/nodes/{nodeId}/hot_threads", DEPRECATED_MESSAGE_CLUSTER_NODES_NODEID_HOT_THREADS), new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/_cluster/nodes/hotthreads", DEPRECATED_MESSAGE_CLUSTER_NODES_HOTTHREADS), new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/_cluster/nodes/{nodeId}/hotthreads", DEPRECATED_MESSAGE_CLUSTER_NODES_NODEID_HOTTHREADS), new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/_nodes/hotthreads", DEPRECATED_MESSAGE_NODES_HOTTHREADS), new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/_nodes/{nodeId}/hotthreads", DEPRECATED_MESSAGE_NODES_NODEID_HOTTHREADS)));
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_nodes/hot_threads"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/hot_threads")));
    }

    @Override
    public String getName() {
        return "nodes_hot_threads_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        NodesHotThreadsRequest nodesHotThreadsRequest = new NodesHotThreadsRequest(nodesIds);
        nodesHotThreadsRequest.threads(request.paramAsInt("threads", nodesHotThreadsRequest.threads()));
        nodesHotThreadsRequest.ignoreIdleThreads(request.paramAsBoolean("ignore_idle_threads", nodesHotThreadsRequest.ignoreIdleThreads()));
        nodesHotThreadsRequest.type(request.param("type", nodesHotThreadsRequest.type()));
        nodesHotThreadsRequest.interval(TimeValue.parseTimeValue(request.param("interval"), nodesHotThreadsRequest.interval(), "interval"));
        nodesHotThreadsRequest.snapshots(request.paramAsInt("snapshots", nodesHotThreadsRequest.snapshots()));
        nodesHotThreadsRequest.timeout(request.param("timeout"));
        return channel -> client.admin().cluster().nodesHotThreads(nodesHotThreadsRequest, (ActionListener<NodesHotThreadsResponse>)new RestResponseListener<NodesHotThreadsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesHotThreadsResponse response) throws Exception {
                StringBuilder sb = new StringBuilder();
                for (NodeHotThreads node : response.getNodes()) {
                    sb.append("::: ").append(node.getNode().toString()).append("\n");
                    Strings.spaceify(3, node.getHotThreads(), sb);
                    sb.append('\n');
                }
                return new BytesRestResponse(RestStatus.OK, sb.toString());
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

