/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.ResourceNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.GetRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.GetResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BytesRestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestResponseListener;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchSourceContext;

public class RestGetSourceAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_source/{id}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_source/{id}")));
    }

    @Override
    public String getName() {
        return "document_get_source_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("id"));
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> {
            if (getRequest.fetchSourceContext() != null && !getRequest.fetchSourceContext().fetchSource()) {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("fetching source can not be disabled");
                channel.sendResponse(new BytesRestResponse((RestChannel)channel, validationError));
            } else {
                client.get(getRequest, new RestGetSourceResponseListener((RestChannel)channel, request));
            }
        };
    }

    static class RestGetSourceResponseListener
    extends RestResponseListener<GetResponse> {
        private final RestRequest request;

        RestGetSourceResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        @Override
        public RestResponse buildResponse(GetResponse response) throws Exception {
            this.checkResource(response);
            XContentBuilder builder = this.channel.newBuilder(this.request.getMediaType(), false);
            BytesReference source = response.getSourceInternal();
            try (StreamInput stream = source.streamInput();){
                builder.rawValue(stream, MediaTypeRegistry.xContentType(source));
            }
            return new BytesRestResponse(RestStatus.OK, builder);
        }

        private void checkResource(GetResponse response) {
            String index = response.getIndex();
            String id = response.getId();
            if (!response.isExists()) {
                throw new ResourceNotFoundException("Document not found [" + index + "]/[" + id + "]", new Object[0]);
            }
            if (response.isSourceEmpty()) {
                throw new ResourceNotFoundException("Source not found [" + index + "]/[" + id + "]", new Object[0]);
            }
        }
    }
}

