/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.ScriptDocValues;
import org.graylog.shaded.opensearch2.org.opensearch.script.DynamicMap;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptContext;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.LeafSearchLookup;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SourceLookup;

@PublicApi(since="1.0.0")
public abstract class FieldScript {
    public static final String[] PARAMETERS = new String[0];
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DynamicMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
        deprecationLogger.deprecate("field-script_doc", "Accessing variable [doc] via [params.doc] from within an field-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.deprecate("field-script__doc", "Accessing variable [doc] via [params._doc] from within an field-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("field", Factory.class);

    public FieldScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        params = new HashMap<String, Object>(params);
        params.putAll(this.leafLookup.asMap());
        this.params = new DynamicMap(params, PARAMS_FUNCTIONS);
    }

    protected FieldScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public abstract Object execute();

    protected final LeafSearchLookup getLeafLookup() {
        return this.leafLookup;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public final Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    @PublicApi(since="1.0.0")
    public static interface LeafFactory {
        public FieldScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

