/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrix;

public class InternalAdjacencyMatrix
extends InternalMultiBucketAggregation<InternalAdjacencyMatrix, InternalBucket>
implements AdjacencyMatrix {
    private final List<InternalBucket> buckets;
    private Map<String, InternalBucket> bucketMap;

    public InternalAdjacencyMatrix(String name, List<InternalBucket> buckets, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
    }

    public InternalAdjacencyMatrix(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new InternalBucket(in));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.buckets.size());
        for (InternalBucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public String getWriteableName() {
        return "adjacency_matrix";
    }

    @Override
    public InternalAdjacencyMatrix create(List<InternalBucket> buckets) {
        return new InternalAdjacencyMatrix(this.name, buckets, this.metadata);
    }

    @Override
    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.key, prototype.docCount, aggregations);
    }

    @Override
    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public InternalBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, InternalBucket>(this.buckets.size());
            for (InternalBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        HashMap<String, ArrayList<InternalBucket>> bucketsMap = new HashMap<String, ArrayList<InternalBucket>>();
        for (InternalAggregation internalAggregation : aggregations) {
            InternalAdjacencyMatrix filters = (InternalAdjacencyMatrix)internalAggregation;
            for (InternalBucket bucket : filters.buckets) {
                ArrayList<InternalBucket> sameRangeList = (ArrayList<InternalBucket>)bucketsMap.get(bucket.key);
                if (sameRangeList == null) {
                    sameRangeList = new ArrayList<InternalBucket>(aggregations.size());
                    bucketsMap.put(bucket.key, sameRangeList);
                }
                sameRangeList.add(bucket);
            }
        }
        ArrayList<InternalBucket> reducedBuckets = new ArrayList<InternalBucket>(bucketsMap.size());
        for (List sameRangeList : bucketsMap.values()) {
            InternalMultiBucketAggregation.InternalBucket reducedBucket = this.reduceBucket(sameRangeList, reduceContext);
            if (((InternalBucket)reducedBucket).docCount < 1L) continue;
            reducedBuckets.add((InternalBucket)reducedBucket);
        }
        reduceContext.consumeBucketsAndMaybeBreak(reducedBuckets.size());
        Collections.sort(reducedBuckets, Comparator.comparing(InternalBucket::getKey));
        InternalAdjacencyMatrix internalAdjacencyMatrix = new InternalAdjacencyMatrix(this.name, reducedBuckets, this.getMetadata());
        return internalAdjacencyMatrix;
    }

    @Override
    protected InternalBucket reduceBucket(List<InternalBucket> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        InternalBucket reduced = null;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (InternalBucket bucket : buckets) {
            if (reduced == null) {
                reduced = new InternalBucket(bucket.key, bucket.docCount, bucket.aggregations);
            } else {
                reduced.docCount += bucket.docCount;
            }
            aggregationsList.add(bucket.aggregations);
        }
        reduced.aggregations = InternalAggregations.reduce(aggregationsList, context);
        return reduced;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (InternalBucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalAdjacencyMatrix that = (InternalAdjacencyMatrix)obj;
        return Objects.equals(this.buckets, that.buckets);
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements AdjacencyMatrix.Bucket {
        private final String key;
        private long docCount;
        InternalAggregations aggregations;

        public InternalBucket(String key, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public InternalBucket(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)other;
            return Objects.equals(this.key, that.key) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.docCount, this.aggregations);
        }
    }
}

