/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;

public interface CompositeAggregation
extends MultiBucketsAggregation {
    public List<? extends Bucket> getBuckets();

    public Map<String, Object> afterKey();

    public static XContentBuilder bucketToXContent(Bucket bucket, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        CompositeAggregation.buildCompositeMap(Aggregation.CommonFields.KEY.getPreferredName(), (Map<String, Object>)bucket.getKey(), builder);
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), bucket.getDocCount());
        bucket.getAggregations().toXContentInternal(builder, params);
        builder.endObject();
        return builder;
    }

    public static XContentBuilder toXContentFragment(CompositeAggregation aggregation, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (aggregation.afterKey() != null) {
            CompositeAggregation.buildCompositeMap("after_key", aggregation.afterKey(), builder);
        }
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : aggregation.getBuckets()) {
            CompositeAggregation.bucketToXContent(bucket, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static void buildCompositeMap(String fieldName, Map<String, Object> composite, XContentBuilder builder) throws IOException {
        builder.startObject(fieldName);
        for (Map.Entry<String, Object> entry : composite.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
    }

    public static interface Bucket
    extends MultiBucketsAggregation.Bucket {
        @Override
        public Map<String, Object> getKey();
    }
}

