/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.Derivative;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.ParsedSimpleValue;

public class ParsedDerivative
extends ParsedSimpleValue
implements Derivative {
    private double normalizedValue;
    private String normalizedAsString;
    private boolean hasNormalizationFactor;
    private static final ParseField NORMALIZED_AS_STRING = new ParseField("normalized_value_as_string", new String[0]);
    private static final ParseField NORMALIZED = new ParseField("normalized_value", new String[0]);
    private static final ObjectParser<ParsedDerivative, Void> PARSER = new ObjectParser(ParsedDerivative.class.getSimpleName(), true, ParsedDerivative::new);

    @Override
    public double normalizedValue() {
        return this.normalizedValue;
    }

    @Override
    public String getType() {
        return "derivative";
    }

    public static ParsedDerivative fromXContent(XContentParser parser, String name) {
        ParsedDerivative derivative = PARSER.apply(parser, null);
        derivative.setName(name);
        return derivative;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, params);
        if (this.hasNormalizationFactor) {
            boolean hasValue = !Double.isNaN(this.normalizedValue);
            builder.field(NORMALIZED.getPreferredName(), hasValue ? Double.valueOf(this.normalizedValue) : null);
            if (hasValue && this.normalizedAsString != null) {
                builder.field(NORMALIZED_AS_STRING.getPreferredName(), this.normalizedAsString);
            }
        }
        return builder;
    }

    static {
        ParsedDerivative.declareSingleValueFields(PARSER, Double.NaN);
        PARSER.declareField((agg, normalized) -> {
            agg.normalizedValue = normalized;
            agg.hasNormalizationFactor = true;
        }, (parser, context) -> ParsedDerivative.parseDouble(parser, Double.NaN), NORMALIZED, ObjectParser.ValueType.DOUBLE_OR_NULL);
        PARSER.declareString((agg, normalAsString) -> {
            agg.normalizedAsString = normalAsString;
        }, NORMALIZED_AS_STRING);
    }
}

