/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.suggest;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.BytesRefs;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.NamedAnalyzer;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.SuggestionSearchContext;

@PublicApi(since="1.0.0")
public abstract class SuggestionBuilder<T extends SuggestionBuilder<T>>
implements NamedWriteable,
ToXContentFragment {
    protected final String field;
    protected String text;
    protected String prefix;
    protected String regex;
    protected String analyzer;
    protected Integer size;
    protected Integer shardSize;
    protected static final ParseField TEXT_FIELD = new ParseField("text", new String[0]);
    protected static final ParseField PREFIX_FIELD = new ParseField("prefix", new String[0]);
    protected static final ParseField REGEX_FIELD = new ParseField("regex", new String[0]);
    protected static final ParseField FIELDNAME_FIELD = new ParseField("field", new String[0]);
    protected static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    protected static final ParseField SIZE_FIELD = new ParseField("size", new String[0]);
    protected static final ParseField SHARDSIZE_FIELD = new ParseField("shard_size", new String[0]);

    protected SuggestionBuilder(String field) {
        Objects.requireNonNull(field, "suggestion requires a field name");
        if (field.isEmpty()) {
            throw new IllegalArgumentException("suggestion field name is empty");
        }
        this.field = field;
    }

    protected SuggestionBuilder(String field, SuggestionBuilder<?> in) {
        this(field);
        this.text = in.text;
        this.prefix = in.prefix;
        this.regex = in.regex;
        this.analyzer = in.analyzer;
        this.size = in.size;
        this.shardSize = in.shardSize;
    }

    protected SuggestionBuilder(StreamInput in) throws IOException {
        this.field = in.readString();
        this.text = in.readOptionalString();
        this.prefix = in.readOptionalString();
        this.regex = in.readOptionalString();
        this.analyzer = in.readOptionalString();
        this.size = in.readOptionalVInt();
        this.shardSize = in.readOptionalVInt();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeOptionalString(this.text);
        out.writeOptionalString(this.prefix);
        out.writeOptionalString(this.regex);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalVInt(this.size);
        out.writeOptionalVInt(this.shardSize);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public T text(String text) {
        this.text = text;
        return (T)this;
    }

    public String text() {
        return this.text;
    }

    protected T prefix(String prefix) {
        this.prefix = prefix;
        return (T)this;
    }

    public String prefix() {
        return this.prefix;
    }

    protected T regex(String regex) {
        this.regex = regex;
        return (T)this;
    }

    public String regex() {
        return this.regex;
    }

    public String field() {
        return this.field;
    }

    public T analyzer(String analyzer) {
        this.analyzer = analyzer;
        return (T)this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public T size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be positive");
        }
        this.size = size;
        return (T)this;
    }

    public Integer size() {
        return this.size;
    }

    public T shardSize(Integer shardSize) {
        this.shardSize = shardSize;
        return (T)this;
    }

    public Integer shardSize() {
        return this.shardSize;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.text != null) {
            builder.field(TEXT_FIELD.getPreferredName(), this.text);
        }
        if (this.prefix != null) {
            builder.field(PREFIX_FIELD.getPreferredName(), this.prefix);
        }
        if (this.regex != null) {
            builder.field(REGEX_FIELD.getPreferredName(), this.regex);
        }
        builder.startObject(this.getSuggesterName());
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        builder.field(FIELDNAME_FIELD.getPreferredName(), this.field);
        if (this.size != null) {
            builder.field(SIZE_FIELD.getPreferredName(), this.size);
        }
        if (this.shardSize != null) {
            builder.field(SHARDSIZE_FIELD.getPreferredName(), this.shardSize);
        }
        builder = this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    static SuggestionBuilder<?> fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String suggestText = null;
        String prefix = null;
        String regex = null;
        SuggestionBuilder suggestionBuilder = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (TEXT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    suggestText = parser.text();
                    continue;
                }
                if (PREFIX_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    prefix = parser.text();
                    continue;
                }
                if (REGEX_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    regex = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "suggestion does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            suggestionBuilder = parser.namedObject(SuggestionBuilder.class, currentFieldName, null);
        }
        if (suggestionBuilder == null) {
            throw new OpenSearchParseException("missing suggestion object", new Object[0]);
        }
        if (suggestText != null) {
            suggestionBuilder.text(suggestText);
        }
        if (prefix != null) {
            suggestionBuilder.prefix(prefix);
        }
        if (regex != null) {
            suggestionBuilder.regex(regex);
        }
        return suggestionBuilder;
    }

    protected abstract SuggestionSearchContext.SuggestionContext build(QueryShardContext var1) throws IOException;

    protected void populateCommonFields(MapperService mapperService, SuggestionSearchContext.SuggestionContext suggestionContext) {
        Objects.requireNonNull(this.field, "field must not be null");
        MappedFieldType fieldType = mapperService.fieldType(this.field);
        if (fieldType == null) {
            throw new IllegalArgumentException("no mapping found for field [" + this.field + "]");
        }
        if (this.analyzer == null) {
            if (fieldType.getTextSearchInfo().getSearchAnalyzer() == null) {
                suggestionContext.setAnalyzer(mapperService.searchAnalyzer());
            } else {
                suggestionContext.setAnalyzer(fieldType.getTextSearchInfo().getSearchAnalyzer());
            }
        } else {
            NamedAnalyzer luceneAnalyzer = mapperService.getNamedAnalyzer(this.analyzer);
            if (luceneAnalyzer == null) {
                throw new IllegalArgumentException("analyzer [" + this.analyzer + "] doesn't exists");
            }
            suggestionContext.setAnalyzer(luceneAnalyzer);
        }
        suggestionContext.setField(fieldType.name());
        if (this.size != null) {
            suggestionContext.setSize(this.size);
        }
        if (this.shardSize != null) {
            suggestionContext.setShardSize(this.shardSize);
        } else {
            suggestionContext.setShardSize(Math.max(suggestionContext.getSize(), 5));
        }
        if (this.text != null) {
            suggestionContext.setText(BytesRefs.toBytesRef(this.text));
        }
        if (this.prefix != null) {
            suggestionContext.setPrefix(BytesRefs.toBytesRef(this.prefix));
        }
        if (this.regex != null) {
            suggestionContext.setRegex(BytesRefs.toBytesRef(this.regex));
        }
        if (this.text != null && this.prefix == null) {
            suggestionContext.setPrefix(BytesRefs.toBytesRef(this.text));
        } else if (this.text == null && this.prefix != null) {
            suggestionContext.setText(BytesRefs.toBytesRef(this.prefix));
        } else if (this.text == null && this.regex != null) {
            suggestionContext.setText(BytesRefs.toBytesRef(this.regex));
        }
    }

    private String getSuggesterName() {
        return this.getWriteableName();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SuggestionBuilder other = (SuggestionBuilder)obj;
        return Objects.equals(this.text, other.text()) && Objects.equals(this.prefix, other.prefix()) && Objects.equals(this.regex, other.regex()) && Objects.equals(this.field, other.field()) && Objects.equals(this.analyzer, other.analyzer()) && Objects.equals(this.size, other.size()) && Objects.equals(this.shardSize, other.shardSize()) && this.doEquals(other);
    }

    protected abstract boolean doEquals(T var1);

    public final int hashCode() {
        return Objects.hash(this.text, this.prefix, this.regex, this.field, this.analyzer, this.size, this.shardSize, this.doHashCode());
    }

    protected abstract int doHashCode();
}

