/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.snapshots;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotId;

@PublicApi(since="1.0.0")
public final class Snapshot
implements Writeable {
    private final String repository;
    private final SnapshotId snapshotId;
    private final int hashCode;

    public Snapshot(String repository, SnapshotId snapshotId) {
        this.repository = Objects.requireNonNull(repository);
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.hashCode = this.computeHashCode();
    }

    public Snapshot(StreamInput in) throws IOException {
        this.repository = in.readString();
        this.snapshotId = new SnapshotId(in);
        this.hashCode = this.computeHashCode();
    }

    public String getRepository() {
        return this.repository;
    }

    public SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public String toString() {
        return this.repository + ":" + this.snapshotId.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snapshot that = (Snapshot)o;
        return this.repository.equals(that.repository) && this.snapshotId.equals(that.snapshotId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.repository, this.snapshotId);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.repository);
        this.snapshotId.writeTo(out);
    }
}

