/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.snapshots;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.SnapshotsInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.Snapshot;

public class UpdateIndexShardSnapshotStatusRequest
extends ClusterManagerNodeRequest<UpdateIndexShardSnapshotStatusRequest> {
    private final Snapshot snapshot;
    private final ShardId shardId;
    private final SnapshotsInProgress.ShardSnapshotStatus status;

    public UpdateIndexShardSnapshotStatusRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = new Snapshot(in);
        this.shardId = new ShardId(in);
        this.status = SnapshotsInProgress.ShardSnapshotStatus.readFrom(in);
    }

    public UpdateIndexShardSnapshotStatusRequest(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
        this.snapshot = snapshot;
        this.shardId = shardId;
        this.status = status;
        this.clusterManagerNodeTimeout = TimeValue.timeValueNanos(Long.MAX_VALUE);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.snapshot.writeTo(out);
        this.shardId.writeTo(out);
        this.status.writeTo(out);
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public SnapshotsInProgress.ShardSnapshotStatus status() {
        return this.status;
    }

    public String toString() {
        return String.valueOf(this.snapshot) + ", shardId [" + String.valueOf(this.shardId) + "], status [" + String.valueOf((Object)this.status.state()) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateIndexShardSnapshotStatusRequest that = (UpdateIndexShardSnapshotStatusRequest)o;
        return this.snapshot.equals(that.snapshot) && this.shardId.equals(that.shardId) && this.status.equals(that.status);
    }

    public int hashCode() {
        return Objects.hash(this.snapshot, this.shardId, this.status);
    }
}

