/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchSecurityException;
import org.graylog.shaded.opensearch2.org.opensearch.action.StepListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ChannelActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.GroupedActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.TaskId;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.CancellableTask;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskManager;
import org.graylog.shaded.opensearch2.org.opensearch.transport.EmptyTransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TaskCancellationService {
    public static final String BAN_PARENT_ACTION_NAME = "internal:admin/tasks/ban";
    private static final Logger logger = LogManager.getLogger(TaskCancellationService.class);
    private final TransportService transportService;
    private final TaskManager taskManager;

    public TaskCancellationService(TransportService transportService) {
        this.transportService = transportService;
        this.taskManager = transportService.getTaskManager();
        transportService.registerRequestHandler(BAN_PARENT_ACTION_NAME, "same", x$0 -> new BanParentTaskRequest(x$0), new BanParentRequestHandler());
    }

    private String localNodeId() {
        return this.transportService.getLocalNode().getId();
    }

    void cancelTaskAndDescendants(CancellableTask task, String reason, boolean waitForCompletion, ActionListener<Void> listener) {
        TaskId taskId = task.taskInfo(this.localNodeId(), false).getTaskId();
        if (task.shouldCancelChildrenOnCancellation()) {
            logger.trace("cancelling task [{}] and its descendants", (Object)taskId);
            StepListener<Void> completedListener = new StepListener<Void>();
            GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.map(completedListener, r -> null), 3);
            Collection<DiscoveryNode> childrenNodes = this.taskManager.startBanOnChildrenNodes(task.getId(), () -> {
                logger.trace("child tasks of parent [{}] are completed", (Object)taskId);
                groupedListener.onResponse(null);
            });
            this.taskManager.cancel(task, reason, () -> {
                logger.trace("task [{}] is cancelled", (Object)taskId);
                groupedListener.onResponse(null);
            });
            StepListener<Void> banOnNodesListener = new StepListener<Void>();
            this.setBanOnNodes(reason, waitForCompletion, task, childrenNodes, banOnNodesListener);
            banOnNodesListener.whenComplete(groupedListener::onResponse, groupedListener::onFailure);
            Runnable removeBansRunnable = this.transportService.getThreadPool().getThreadContext().preserveContext(() -> this.removeBanOnNodes(task, childrenNodes));
            completedListener.whenComplete(r -> removeBansRunnable.run(), e -> removeBansRunnable.run());
            if (waitForCompletion) {
                completedListener.whenComplete(r -> listener.onResponse(null), listener::onFailure);
            } else {
                banOnNodesListener.whenComplete(r -> listener.onResponse(null), listener::onFailure);
            }
        } else {
            logger.trace("task [{}] doesn't have any children that should be cancelled", (Object)taskId);
            if (waitForCompletion) {
                this.taskManager.cancel(task, reason, () -> listener.onResponse(null));
            } else {
                this.taskManager.cancel(task, reason, () -> {});
                listener.onResponse(null);
            }
        }
    }

    private void setBanOnNodes(String reason, boolean waitForCompletion, CancellableTask task, Collection<DiscoveryNode> childNodes, ActionListener<Void> listener) {
        if (childNodes.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        final TaskId taskId = new TaskId(this.localNodeId(), task.getId());
        logger.trace("cancelling child tasks of [{}] on child nodes {}", (Object)taskId, childNodes);
        final GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.map(listener, r -> null), childNodes.size());
        BanParentTaskRequest banRequest = BanParentTaskRequest.createSetBanParentTaskRequest(taskId, reason, waitForCompletion);
        for (final DiscoveryNode node : childNodes) {
            this.transportService.sendRequest(node, BAN_PARENT_ACTION_NAME, banRequest, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    logger.trace("sent ban for tasks with the parent [{}] to the node [{}]", (Object)taskId, (Object)node);
                    groupedListener.onResponse(null);
                }

                @Override
                public void handleException(TransportException exp) {
                    assert (!(ExceptionsHelper.unwrapCause(exp) instanceof OpenSearchSecurityException));
                    logger.warn("Cannot send ban for tasks with the parent [{}] to the node [{}]", (Object)taskId, (Object)node);
                    groupedListener.onFailure(exp);
                }
            });
        }
    }

    private void removeBanOnNodes(CancellableTask task, Collection<DiscoveryNode> childNodes) {
        final BanParentTaskRequest request = BanParentTaskRequest.createRemoveBanParentTaskRequest(new TaskId(this.localNodeId(), task.getId()));
        for (final DiscoveryNode node : childNodes) {
            logger.trace("Sending remove ban for tasks with the parent [{}] to the node [{}]", (Object)request.parentTaskId, (Object)node);
            this.transportService.sendRequest(node, BAN_PARENT_ACTION_NAME, request, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp) {
                    assert (!(ExceptionsHelper.unwrapCause(exp) instanceof OpenSearchSecurityException));
                    logger.info("failed to remove the parent ban for task {} on node {}", (Object)request.parentTaskId, (Object)node);
                }
            });
        }
    }

    private class BanParentRequestHandler
    implements TransportRequestHandler<BanParentTaskRequest> {
        private BanParentRequestHandler() {
        }

        @Override
        public void messageReceived(BanParentTaskRequest request, TransportChannel channel, Task task) throws Exception {
            if (request.ban) {
                logger.debug("Received ban for the parent [{}] on the node [{}], reason: [{}]", (Object)request.parentTaskId, (Object)TaskCancellationService.this.localNodeId(), (Object)request.reason);
                List<CancellableTask> childTasks = TaskCancellationService.this.taskManager.setBan(request.parentTaskId, request.reason);
                GroupedActionListener<Void> listener = new GroupedActionListener<Void>(ActionListener.map(new ChannelActionListener(channel, TaskCancellationService.BAN_PARENT_ACTION_NAME, request), r -> TransportResponse.Empty.INSTANCE), childTasks.size() + 1);
                for (CancellableTask childTask : childTasks) {
                    TaskCancellationService.this.cancelTaskAndDescendants(childTask, request.reason, request.waitForCompletion, listener);
                }
                listener.onResponse(null);
            } else {
                logger.debug("Removing ban for the parent [{}] on the node [{}]", (Object)request.parentTaskId, (Object)TaskCancellationService.this.localNodeId());
                TaskCancellationService.this.taskManager.removeBan(request.parentTaskId);
                channel.sendResponse(TransportResponse.Empty.INSTANCE);
            }
        }
    }

    private static class BanParentTaskRequest
    extends TransportRequest {
        private final TaskId parentTaskId;
        private final boolean ban;
        private final boolean waitForCompletion;
        private final String reason;

        static BanParentTaskRequest createSetBanParentTaskRequest(TaskId parentTaskId, String reason, boolean waitForCompletion) {
            return new BanParentTaskRequest(parentTaskId, reason, waitForCompletion);
        }

        static BanParentTaskRequest createRemoveBanParentTaskRequest(TaskId parentTaskId) {
            return new BanParentTaskRequest(parentTaskId);
        }

        private BanParentTaskRequest(TaskId parentTaskId, String reason, boolean waitForCompletion) {
            this.parentTaskId = parentTaskId;
            this.ban = true;
            this.reason = reason;
            this.waitForCompletion = waitForCompletion;
        }

        private BanParentTaskRequest(TaskId parentTaskId) {
            this.parentTaskId = parentTaskId;
            this.ban = false;
            this.reason = null;
            this.waitForCompletion = false;
        }

        private BanParentTaskRequest(StreamInput in) throws IOException {
            super(in);
            this.parentTaskId = TaskId.readFromStream(in);
            this.ban = in.readBoolean();
            this.reason = this.ban ? in.readString() : null;
            this.waitForCompletion = in.getVersion().onOrAfter(LegacyESVersion.V_7_8_0) ? in.readBoolean() : false;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.parentTaskId.writeTo(out);
            out.writeBoolean(this.ban);
            if (this.ban) {
                out.writeString(this.reason);
            }
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_8_0)) {
                out.writeBoolean(this.waitForCompletion);
            }
        }
    }
}

