/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing;

import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Span;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanScope;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.TracerContextStorage;

@InternalApi
class DefaultSpanScope
implements SpanScope {
    private final Span span;
    private final SpanScope previousSpanScope;
    private final Span beforeSpan;
    private static final ThreadLocal<SpanScope> spanScopeThreadLocal = new ThreadLocal();
    private final TracerContextStorage<String, Span> tracerContextStorage;

    private DefaultSpanScope(Span span, Span beforeSpan, SpanScope previousSpanScope, TracerContextStorage<String, Span> tracerContextStorage) {
        this.span = Objects.requireNonNull(span);
        this.beforeSpan = beforeSpan;
        this.previousSpanScope = previousSpanScope;
        this.tracerContextStorage = tracerContextStorage;
    }

    public static SpanScope create(Span span, TracerContextStorage<String, Span> tracerContextStorage) {
        SpanScope beforeSpanScope = spanScopeThreadLocal.get();
        Span beforeSpan = tracerContextStorage.get("current_span");
        DefaultSpanScope newSpanScope = new DefaultSpanScope(span, beforeSpan, beforeSpanScope, tracerContextStorage);
        return newSpanScope;
    }

    @Override
    public void close() {
        this.detach();
    }

    @Override
    public SpanScope attach() {
        spanScopeThreadLocal.set(this);
        this.tracerContextStorage.put("current_span", this.span);
        return this;
    }

    private void detach() {
        spanScopeThreadLocal.set(this.previousSpanScope);
        if (this.beforeSpan != null) {
            this.tracerContextStorage.put("current_span", this.beforeSpan);
        } else {
            this.tracerContextStorage.put("current_span", null);
        }
    }

    @Override
    public Span getSpan() {
        return this.span;
    }

    static SpanScope getCurrentSpanScope() {
        return spanScopeThreadLocal.get();
    }
}

