/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.publisher;

import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.graylog.shaded.opensearch2.reactor.core.CoreSubscriber;
import org.graylog.shaded.opensearch2.reactor.core.Fuseable;
import org.graylog.shaded.opensearch2.reactor.core.Scannable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Flux;
import org.graylog.shaded.opensearch2.reactor.core.publisher.FluxIterable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Operators;
import org.graylog.shaded.opensearch2.reactor.core.publisher.SourceProducer;

final class FluxStream<T>
extends Flux<T>
implements Fuseable,
SourceProducer<T> {
    final Supplier<? extends Stream<? extends T>> streamSupplier;

    FluxStream(Supplier<? extends Stream<? extends T>> streamSupplier) {
        this.streamSupplier = Objects.requireNonNull(streamSupplier, "streamSupplier");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Spliterator sp;
        boolean knownToBeFinite;
        Stream<T> stream;
        try {
            stream = Objects.requireNonNull(this.streamSupplier.get(), "The stream supplier returned a null Stream");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        try {
            Spliterator spliterator = Objects.requireNonNull(stream.spliterator(), "The stream returned a null Spliterator");
            knownToBeFinite = spliterator.hasCharacteristics(64);
            sp = spliterator;
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        FluxIterable.subscribe(actual, sp, knownToBeFinite, stream::close);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

