/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.bn;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.LowerCaseFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.StopFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.WordlistLoader;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.bn.BengaliNormalizationFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.bn.BengaliStemFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;

public final class BengaliAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public BengaliAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    public BengaliAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public BengaliAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new DecimalDigitFilter(result);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new IndicNormalizationFilter(result);
        result = new BengaliNormalizationFilter(result);
        result = new StopFilter(result, this.stopwords);
        result = new BengaliStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new LowerCaseFilter(in);
        result = new DecimalDigitFilter(result);
        result = new IndicNormalizationFilter(result);
        result = new BengaliNormalizationFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(BengaliAnalyzer.class.getResourceAsStream(BengaliAnalyzer.DEFAULT_STOPWORD_FILE), BengaliAnalyzer.DEFAULT_STOPWORD_FILE), BengaliAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

