/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.synonym.word2vec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.synonym.word2vec.Dl4jModelReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.synonym.word2vec.Word2VecSynonymProvider;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ResourceLoader;

public class Word2VecSynonymProviderFactory {
    private static Map<String, Word2VecSynonymProvider> word2vecSynonymProviders = new ConcurrentHashMap<String, Word2VecSynonymProvider>();

    public static Word2VecSynonymProvider getSynonymProvider(ResourceLoader loader, String modelFileName, Word2VecSupportedFormats format) throws IOException {
        Word2VecSynonymProvider synonymProvider = word2vecSynonymProviders.get(modelFileName);
        if (synonymProvider == null) {
            try (InputStream stream = loader.openResource(modelFileName);
                 Dl4jModelReader reader = Word2VecSynonymProviderFactory.getModelReader(format, stream);){
                synonymProvider = new Word2VecSynonymProvider(reader.read());
            }
            word2vecSynonymProviders.put(modelFileName, synonymProvider);
        }
        return synonymProvider;
    }

    private static Dl4jModelReader getModelReader(Word2VecSupportedFormats format, InputStream stream) {
        switch (format) {
            case DL4J: {
                return new Dl4jModelReader(stream);
            }
        }
        return null;
    }

    static enum Word2VecSupportedFormats {
        DL4J;

    }
}

