/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.NumericDocValuesField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.BufferedUpdates;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocumentsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FrozenBufferedUpdates;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexingChain;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LiveIndexWriterConfig;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PendingSoftDeletes;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Sorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FlushInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.TrackingDirectoryWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.InfoStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.SetOnce;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.StringHelper;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Version;

final class DocumentsWriterPerThread
implements Accountable,
Lock {
    private Throwable abortingException;
    private static final boolean INFO_VERBOSE = false;
    final Codec codec;
    final TrackingDirectoryWrapper directory;
    private final IndexingChain indexingChain;
    private final BufferedUpdates pendingUpdates;
    private final SegmentInfo segmentInfo;
    private boolean aborted = false;
    private SetOnce<Boolean> flushPending = new SetOnce();
    private volatile long lastCommittedBytesUsed;
    private SetOnce<Boolean> hasFlushed = new SetOnce();
    private final FieldInfos.Builder fieldInfos;
    private final InfoStream infoStream;
    private int numDocsInRAM;
    final DocumentsWriterDeleteQueue deleteQueue;
    private final DocumentsWriterDeleteQueue.DeleteSlice deleteSlice;
    private final NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
    private final AtomicLong pendingNumDocs;
    private final LiveIndexWriterConfig indexWriterConfig;
    private final boolean enableTestPoints;
    private final ReentrantLock lock = new ReentrantLock();
    private int[] deleteDocIDs = new int[0];
    private int numDeletedDocIds = 0;
    private final IndexingChain.ReservedField<NumericDocValuesField> parentField;
    private final Set<String> filesToDelete = new HashSet<String>();

    private void onAbortingException(Throwable throwable) {
        assert (throwable != null) : "aborting exception must not be null";
        assert (this.abortingException == null) : "aborting exception has already been set";
        this.abortingException = throwable;
    }

    final boolean isAborted() {
        return this.aborted;
    }

    void abort() throws IOException {
        this.aborted = true;
        this.pendingNumDocs.addAndGet(-this.numDocsInRAM);
        try {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "now abort");
            }
            try {
                this.indexingChain.abort();
            }
            finally {
                this.pendingUpdates.clear();
            }
        }
        finally {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "done abort");
            }
        }
    }

    DocumentsWriterPerThread(int indexMajorVersionCreated, String segmentName, Directory directoryOrig, Directory directory, LiveIndexWriterConfig indexWriterConfig, DocumentsWriterDeleteQueue deleteQueue, FieldInfos.Builder fieldInfos, AtomicLong pendingNumDocs, boolean enableTestPoints) {
        this.directory = new TrackingDirectoryWrapper(directory);
        this.fieldInfos = fieldInfos;
        this.indexWriterConfig = indexWriterConfig;
        this.infoStream = indexWriterConfig.getInfoStream();
        this.codec = indexWriterConfig.getCodec();
        this.pendingNumDocs = pendingNumDocs;
        this.pendingUpdates = new BufferedUpdates(segmentName);
        this.deleteQueue = Objects.requireNonNull(deleteQueue);
        assert (this.numDocsInRAM == 0) : "num docs " + this.numDocsInRAM;
        this.deleteSlice = deleteQueue.newSlice();
        this.segmentInfo = new SegmentInfo(directoryOrig, Version.LATEST, Version.LATEST, segmentName, -1, false, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), Collections.emptyMap(), indexWriterConfig.getIndexSort());
        assert (this.numDocsInRAM == 0);
        this.enableTestPoints = enableTestPoints;
        this.indexingChain = new IndexingChain(indexMajorVersionCreated, this.segmentInfo, this.directory, fieldInfos, indexWriterConfig, this::onAbortingException);
        this.parentField = indexWriterConfig.getParentField() != null ? this.indexingChain.markAsReserved(new NumericDocValuesField(indexWriterConfig.getParentField(), -1L)) : null;
    }

    final void testPoint(String message) {
        if (this.enableTestPoints) {
            assert (this.infoStream.isEnabled("TP"));
            this.infoStream.message("TP", message);
        }
    }

    private void reserveOneDoc() {
        if (this.pendingNumDocs.incrementAndGet() > (long)IndexWriter.getActualMaxDocs()) {
            this.pendingNumDocs.decrementAndGet();
            throw new IllegalArgumentException("number of documents in the index cannot exceed " + IndexWriter.getActualMaxDocs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs, DocumentsWriterDeleteQueue.Node<?> deleteNode, DocumentsWriter.FlushNotifications flushNotifications, Runnable onNewDocOnRAM) throws IOException {
        try {
            this.testPoint("DocumentsWriterPerThread addDocuments start");
            assert (this.abortingException == null) : "DWPT has hit aborting exception but is still indexing";
            int docsInRamBefore = this.numDocsInRAM;
            boolean allDocsIndexed = false;
            try {
                Iterator<? extends Iterable<? extends IndexableField>> iterator = docs.iterator();
                while (iterator.hasNext()) {
                    Iterable<? extends IndexableField> doc = iterator.next();
                    if (this.parentField != null && !iterator.hasNext()) {
                        doc = this.addParentField(doc, this.parentField);
                    }
                    this.reserveOneDoc();
                    try {
                        this.indexingChain.processDocument(this.numDocsInRAM++, doc);
                    }
                    finally {
                        onNewDocOnRAM.run();
                    }
                }
                int numDocs = this.numDocsInRAM - docsInRamBefore;
                if (numDocs > 1) {
                    this.segmentInfo.setHasBlocks();
                }
                allDocsIndexed = true;
                long l = this.finishDocuments(deleteNode, docsInRamBefore);
                if (!allDocsIndexed && !this.aborted) {
                    this.deleteLastDocs(this.numDocsInRAM - docsInRamBefore);
                }
                return l;
            }
            catch (Throwable throwable) {
                if (!allDocsIndexed && !this.aborted) {
                    this.deleteLastDocs(this.numDocsInRAM - docsInRamBefore);
                }
                throw throwable;
            }
        }
        finally {
            this.maybeAbort("updateDocuments", flushNotifications);
        }
    }

    private Iterable<? extends IndexableField> addParentField(Iterable<? extends IndexableField> doc, final IndexableField parentField) {
        return () -> {
            final Iterator first = doc.iterator();
            return new Iterator<IndexableField>(){
                IndexableField additionalField;
                {
                    this.additionalField = parentField;
                }

                @Override
                public boolean hasNext() {
                    return this.additionalField != null || first.hasNext();
                }

                @Override
                public IndexableField next() {
                    if (this.additionalField != null) {
                        IndexableField field = this.additionalField;
                        this.additionalField = null;
                        return field;
                    }
                    if (first.hasNext()) {
                        return (IndexableField)first.next();
                    }
                    throw new NoSuchElementException();
                }
            };
        };
    }

    private long finishDocuments(DocumentsWriterDeleteQueue.Node<?> deleteNode, int docIdUpTo) {
        if (deleteNode != null) {
            long seqNo = this.deleteQueue.add(deleteNode, this.deleteSlice);
            assert (this.deleteSlice.isTail(deleteNode)) : "expected the delete term as the tail item";
            this.deleteSlice.apply(this.pendingUpdates, docIdUpTo);
            return seqNo;
        }
        long seqNo = this.deleteQueue.updateSlice(this.deleteSlice);
        if (seqNo < 0L) {
            seqNo = -seqNo;
            this.deleteSlice.apply(this.pendingUpdates, docIdUpTo);
        } else {
            this.deleteSlice.reset();
        }
        return seqNo;
    }

    private void deleteLastDocs(int docCount) {
        int from = this.numDocsInRAM - docCount;
        int to = this.numDocsInRAM;
        this.deleteDocIDs = ArrayUtil.grow(this.deleteDocIDs, this.numDeletedDocIds + (to - from));
        int docId = from;
        while (docId < to) {
            this.deleteDocIDs[this.numDeletedDocIds++] = docId++;
        }
    }

    public int getNumDocsInRAM() {
        return this.numDocsInRAM;
    }

    FrozenBufferedUpdates prepareFlush() {
        assert (this.numDocsInRAM > 0);
        FrozenBufferedUpdates globalUpdates = this.deleteQueue.freezeGlobalBuffer(this.deleteSlice);
        if (this.deleteSlice != null) {
            this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM);
            assert (this.deleteSlice.isEmpty());
            this.deleteSlice.reset();
        }
        return globalUpdates;
    }

    FlushedSegment flush(DocumentsWriter.FlushNotifications flushNotifications) throws IOException {
        assert (this.flushPending.get() == Boolean.TRUE);
        assert (this.numDocsInRAM > 0);
        assert (this.deleteSlice.isEmpty()) : "all deletes must be applied in prepareFlush";
        this.segmentInfo.setMaxDoc(this.numDocsInRAM);
        SegmentWriteState flushState = new SegmentWriteState(this.infoStream, this.directory, this.segmentInfo, this.fieldInfos.finish(), this.pendingUpdates, new IOContext(new FlushInfo(this.numDocsInRAM, this.lastCommittedBytesUsed)));
        double startMBUsed = (double)this.lastCommittedBytesUsed / 1024.0 / 1024.0;
        if (this.numDeletedDocIds > 0) {
            flushState.liveDocs = new FixedBitSet(this.numDocsInRAM);
            flushState.liveDocs.set(0, this.numDocsInRAM);
            for (int i = 0; i < this.numDeletedDocIds; ++i) {
                flushState.liveDocs.clear(this.deleteDocIDs[i]);
            }
            flushState.delCountOnFlush = this.numDeletedDocIds;
            this.deleteDocIDs = new int[0];
        }
        if (this.aborted) {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "flush: skip because aborting is set");
            }
            return null;
        }
        long t0 = System.nanoTime();
        if (this.infoStream.isEnabled("DWPT")) {
            this.infoStream.message("DWPT", "flush postings as segment " + flushState.segmentInfo.name + " numDocs=" + this.numDocsInRAM);
        }
        try {
            BufferedUpdates segmentDeletes;
            DocIdSetIterator softDeletedDocs = this.indexWriterConfig.getSoftDeletesField() != null ? this.indexingChain.getHasDocValues(this.indexWriterConfig.getSoftDeletesField()) : null;
            Sorter.DocMap sortMap = this.indexingChain.flush(flushState);
            if (softDeletedDocs == null) {
                flushState.softDelCountOnFlush = 0;
            } else {
                flushState.softDelCountOnFlush = PendingSoftDeletes.countSoftDeletes(softDeletedDocs, flushState.liveDocs);
                assert (flushState.segmentInfo.maxDoc() >= flushState.softDelCountOnFlush + flushState.delCountOnFlush);
            }
            this.pendingUpdates.clearDeleteTerms();
            this.segmentInfo.setFiles(new HashSet<String>(this.directory.getCreatedFiles()));
            SegmentCommitInfo segmentInfoPerCommit = new SegmentCommitInfo(this.segmentInfo, 0, flushState.softDelCountOnFlush, -1L, -1L, -1L, StringHelper.randomId());
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "new segment has " + (flushState.liveDocs == null ? 0 : flushState.delCountOnFlush) + " deleted docs");
                this.infoStream.message("DWPT", "new segment has " + flushState.softDelCountOnFlush + " soft-deleted docs");
                this.infoStream.message("DWPT", "new segment has " + (flushState.fieldInfos.hasVectors() ? "vectors" : "no vectors") + "; " + (flushState.fieldInfos.hasNorms() ? "norms" : "no norms") + "; " + (flushState.fieldInfos.hasDocValues() ? "docValues" : "no docValues") + "; " + (flushState.fieldInfos.hasProx() ? "prox" : "no prox") + "; " + (flushState.fieldInfos.hasFreq() ? "freqs" : "no freqs"));
                this.infoStream.message("DWPT", "flushedFiles=" + segmentInfoPerCommit.files());
                this.infoStream.message("DWPT", "flushed codec=" + this.codec);
            }
            if (this.pendingUpdates.deleteQueries.isEmpty() && this.pendingUpdates.numFieldUpdates.get() == 0) {
                this.pendingUpdates.clear();
                segmentDeletes = null;
            } else {
                segmentDeletes = this.pendingUpdates;
            }
            if (this.infoStream.isEnabled("DWPT")) {
                double newSegmentSize = (double)segmentInfoPerCommit.sizeInBytes() / 1024.0 / 1024.0;
                this.infoStream.message("DWPT", "flushed: segment=" + this.segmentInfo.name + " ramUsed=" + this.nf.format(startMBUsed) + " MB newFlushedSize=" + this.nf.format(newSegmentSize) + " MB docs/MB=" + this.nf.format((double)flushState.segmentInfo.maxDoc() / newSegmentSize));
            }
            assert (this.segmentInfo != null);
            FlushedSegment fs = new FlushedSegment(this.infoStream, segmentInfoPerCommit, flushState.fieldInfos, segmentDeletes, flushState.liveDocs, flushState.delCountOnFlush, sortMap);
            this.sealFlushedSegment(fs, sortMap, flushNotifications);
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "flush time " + (double)(System.nanoTime() - t0) / (double)TimeUnit.MILLISECONDS.toNanos(1L) + " ms");
            }
            FlushedSegment flushedSegment = fs;
            return flushedSegment;
        }
        catch (Throwable t) {
            this.onAbortingException(t);
            throw t;
        }
        finally {
            this.maybeAbort("flush", flushNotifications);
            this.hasFlushed.set(Boolean.TRUE);
        }
    }

    private void maybeAbort(String location, DocumentsWriter.FlushNotifications flushNotifications) throws IOException {
        if (this.abortingException != null && !this.aborted) {
            try {
                this.abort();
            }
            finally {
                flushNotifications.onTragicEvent(this.abortingException, location);
            }
        }
    }

    Set<String> pendingFilesToDelete() {
        return this.filesToDelete;
    }

    private FixedBitSet sortLiveDocs(Bits liveDocs, Sorter.DocMap sortMap) {
        assert (liveDocs != null && sortMap != null);
        FixedBitSet sortedLiveDocs = new FixedBitSet(liveDocs.length());
        sortedLiveDocs.set(0, liveDocs.length());
        for (int i = 0; i < liveDocs.length(); ++i) {
            if (liveDocs.get(i)) continue;
            sortedLiveDocs.clear(sortMap.oldToNew(i));
        }
        return sortedLiveDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sealFlushedSegment(FlushedSegment flushedSegment, Sorter.DocMap sortMap, DocumentsWriter.FlushNotifications flushNotifications) throws IOException {
        assert (flushedSegment != null);
        SegmentCommitInfo newSegment = flushedSegment.segmentInfo;
        IndexWriter.setDiagnostics(newSegment.info, "flush");
        IOContext context = new IOContext(new FlushInfo(newSegment.info.maxDoc(), newSegment.sizeInBytes()));
        boolean success = false;
        try {
            if (this.indexWriterConfig.getUseCompoundFile()) {
                Set<String> originalFiles = newSegment.info.files();
                IndexWriter.createCompoundFile(this.infoStream, new TrackingDirectoryWrapper(this.directory), newSegment.info, context, flushNotifications::deleteUnusedFiles);
                this.filesToDelete.addAll(originalFiles);
                newSegment.info.setUseCompoundFile(true);
            }
            this.codec.segmentInfoFormat().write(this.directory, newSegment.info, context);
            if (flushedSegment.liveDocs != null) {
                int delCount = flushedSegment.delCount;
                assert (delCount > 0);
                if (this.infoStream.isEnabled("DWPT")) {
                    this.infoStream.message("DWPT", "flush: write " + delCount + " deletes gen=" + flushedSegment.segmentInfo.getDelGen());
                }
                SegmentCommitInfo info = flushedSegment.segmentInfo;
                Codec codec = info.info.getCodec();
                FixedBitSet bits = sortMap == null ? flushedSegment.liveDocs : this.sortLiveDocs(flushedSegment.liveDocs, sortMap);
                codec.liveDocsFormat().writeLiveDocs(bits, this.directory, info, delCount, context);
                newSegment.setDelCount(delCount);
                newSegment.advanceDelGen();
            }
            success = true;
        }
        finally {
            if (!success && this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "hit exception creating compound file for newly flushed segment " + newSegment.info.name);
            }
        }
    }

    SegmentInfo getSegmentInfo() {
        return this.segmentInfo;
    }

    @Override
    public long ramBytesUsed() {
        assert (this.lock.isHeldByCurrentThread());
        return (long)this.deleteDocIDs.length * 4L + this.pendingUpdates.ramBytesUsed() + this.indexingChain.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        assert (this.lock.isHeldByCurrentThread());
        return List.of(this.pendingUpdates, this.indexingChain);
    }

    public String toString() {
        return "DocumentsWriterPerThread [pendingDeletes=" + this.pendingUpdates + ", segment=" + this.segmentInfo.name + ", aborted=" + this.aborted + ", numDocsInRAM=" + this.numDocsInRAM + ", deleteQueue=" + this.deleteQueue + ", " + this.numDeletedDocIds + " deleted docIds]";
    }

    boolean isFlushPending() {
        return this.flushPending.get() == Boolean.TRUE;
    }

    void setFlushPending() {
        this.flushPending.set(Boolean.TRUE);
    }

    long getLastCommittedBytesUsed() {
        return this.lastCommittedBytesUsed;
    }

    void commitLastBytesUsed(long delta) {
        assert (this.isHeldByCurrentThread());
        assert (this.getCommitLastBytesUsedDelta() == delta) : "delta has changed";
        this.lastCommittedBytesUsed += delta;
    }

    long getCommitLastBytesUsedDelta() {
        assert (this.isHeldByCurrentThread());
        long delta = this.ramBytesUsed() - this.lastCommittedBytesUsed;
        return delta;
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(time, unit);
    }

    boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    boolean hasFlushed() {
        return this.hasFlushed.get() == Boolean.TRUE;
    }

    static final class FlushedSegment {
        final SegmentCommitInfo segmentInfo;
        final FieldInfos fieldInfos;
        final FrozenBufferedUpdates segmentUpdates;
        final FixedBitSet liveDocs;
        final Sorter.DocMap sortMap;
        final int delCount;

        private FlushedSegment(InfoStream infoStream, SegmentCommitInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates segmentUpdates, FixedBitSet liveDocs, int delCount, Sorter.DocMap sortMap) {
            this.segmentInfo = segmentInfo;
            this.fieldInfos = fieldInfos;
            this.segmentUpdates = segmentUpdates != null && segmentUpdates.any() ? new FrozenBufferedUpdates(infoStream, segmentUpdates, segmentInfo) : null;
            this.liveDocs = liveDocs;
            this.delCount = delCount;
            this.sortMap = sortMap;
        }
    }
}

