/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilteredTermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PrefixCodedTerms;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Terms;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.AttributeSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRefComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.StringSorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automata;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.ByteRunAutomaton;

public class TermInSetQuery
extends MultiTermQuery
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermInSetQuery.class);
    private final String field;
    private final PrefixCodedTerms termData;
    private final int termDataHashCode;

    public TermInSetQuery(String field, Collection<BytesRef> terms) {
        this(field, TermInSetQuery.packTerms(field, terms));
    }

    @Deprecated(since="9.10")
    public TermInSetQuery(String field, BytesRef ... terms) {
        this(field, TermInSetQuery.packTerms(field, Arrays.asList(terms)));
    }

    public TermInSetQuery(MultiTermQuery.RewriteMethod rewriteMethod, String field, Collection<BytesRef> terms) {
        super(field, rewriteMethod);
        this.field = field;
        this.termData = TermInSetQuery.packTerms(field, terms);
        this.termDataHashCode = this.termData.hashCode();
    }

    @Deprecated(since="9.10")
    public TermInSetQuery(MultiTermQuery.RewriteMethod rewriteMethod, String field, BytesRef ... terms) {
        this(rewriteMethod, field, Arrays.asList(terms));
    }

    private TermInSetQuery(String field, PrefixCodedTerms termData) {
        super(field, MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE);
        this.field = field;
        this.termData = termData;
        this.termDataHashCode = termData.hashCode();
    }

    private static PrefixCodedTerms packTerms(String field, Collection<BytesRef> terms) {
        boolean sorted;
        final BytesRef[] sortedTerms = terms.toArray(new BytesRef[0]);
        boolean bl = sorted = terms instanceof SortedSet && ((SortedSet)terms).comparator() == null;
        if (!sorted) {
            new StringSorter(BytesRefComparator.NATURAL){

                @Override
                protected void get(BytesRefBuilder builder, BytesRef result, int i) {
                    BytesRef term = sortedTerms[i];
                    result.length = term.length;
                    result.offset = term.offset;
                    result.bytes = term.bytes;
                }

                @Override
                protected void swap(int i, int j) {
                    BytesRef b = sortedTerms[i];
                    sortedTerms[i] = sortedTerms[j];
                    sortedTerms[j] = b;
                }
            }.sort(0, sortedTerms.length);
        }
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        BytesRefBuilder previous = null;
        for (BytesRef term : sortedTerms) {
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else if (previous.get().equals(term)) continue;
            builder.add(field, term);
            previous.copyBytes(term);
        }
        return builder.finish();
    }

    @Override
    public long getTermsCount() throws IOException {
        return this.termData.size();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.field)) {
            return;
        }
        if (this.termData.size() == 1L) {
            visitor.consumeTerms(this, new Term(this.field, this.termData.iterator().next()));
        }
        if (this.termData.size() > 1L) {
            visitor.consumeTermsMatching(this, this.field, this::asByteRunAutomaton);
        }
    }

    private ByteRunAutomaton asByteRunAutomaton() {
        try {
            Automaton a = Automata.makeBinaryStringUnion(this.termData.iterator());
            return new ByteRunAutomaton(a, true, 10000);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermInSetQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(TermInSetQuery other) {
        return this.termDataHashCode == other.termDataHashCode && this.termData.equals(other.termData);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.termDataHashCode;
    }

    @Deprecated
    public PrefixCodedTerms getTermData() {
        return this.termData;
    }

    @Override
    public String toString(String defaultField) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.field);
        builder.append(":(");
        PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
        boolean first = true;
        BytesRef term = iterator.next();
        while (term != null) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(Term.toString(term));
            term = iterator.next();
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.termData.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return new SetEnum(terms.iterator());
    }

    private class SetEnum
    extends FilteredTermsEnum {
        private final PrefixCodedTerms.TermIterator iterator;
        private BytesRef seekTerm;

        SetEnum(TermsEnum termsEnum) {
            super(termsEnum);
            this.iterator = TermInSetQuery.this.termData.iterator();
            this.seekTerm = this.iterator.next();
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
            int cmp = 0;
            while (this.seekTerm != null && (cmp = this.seekTerm.compareTo(term)) < 0) {
                this.seekTerm = this.iterator.next();
            }
            if (this.seekTerm == null) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            if (cmp == 0) {
                return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
            }
            return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
        }

        @Override
        protected BytesRef nextSeekTerm(BytesRef currentTerm) throws IOException {
            if (currentTerm == null) {
                return this.seekTerm;
            }
            while (this.seekTerm != null && this.seekTerm.compareTo(currentTerm) <= 0) {
                this.seekTerm = this.iterator.next();
            }
            return this.seekTerm;
        }
    }
}

