/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectorManager;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldValueHitQueue;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.HitsThresholdChecker;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MaxScoreAccumulator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Sort;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopFieldCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopFieldDocs;

public class TopFieldCollectorManager
implements CollectorManager<TopFieldCollector, TopFieldDocs> {
    private final Sort sort;
    private final int numHits;
    private final FieldDoc after;
    private final HitsThresholdChecker hitsThresholdChecker;
    private final MaxScoreAccumulator minScoreAcc;
    private final List<TopFieldCollector> collectors;
    private final boolean supportsConcurrency;
    private boolean collectorCreated;

    public TopFieldCollectorManager(Sort sort, int numHits, FieldDoc after, int totalHitsThreshold, boolean supportsConcurrency) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (sort.getSort().length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (after != null) {
            if (after.fields == null) {
                throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
            }
            if (after.fields.length != sort.getSort().length) {
                throw new IllegalArgumentException("after.fields has " + after.fields.length + " values but sort has " + sort.getSort().length);
            }
        }
        this.sort = sort;
        this.numHits = numHits;
        this.after = after;
        this.supportsConcurrency = supportsConcurrency;
        this.hitsThresholdChecker = supportsConcurrency ? HitsThresholdChecker.createShared(Math.max(totalHitsThreshold, numHits)) : HitsThresholdChecker.create(Math.max(totalHitsThreshold, numHits));
        this.minScoreAcc = supportsConcurrency ? new MaxScoreAccumulator() : null;
        this.collectors = new ArrayList<TopFieldCollector>();
    }

    public TopFieldCollectorManager(Sort sort, int numHits, FieldDoc after, int totalHitsThreshold) {
        this(sort, numHits, after, totalHitsThreshold, true);
    }

    public TopFieldCollectorManager(Sort sort, int numHits, int totalHitsThreshold) {
        this(sort, numHits, null, totalHitsThreshold, true);
    }

    @Override
    public TopFieldCollector newCollector() {
        TopFieldCollector collector;
        if (this.collectorCreated && !this.supportsConcurrency) {
            throw new IllegalStateException("This TopFieldCollectorManager was created without concurrency (supportsConcurrency=false), but multiple collectors are being created");
        }
        this.collectorCreated = true;
        FieldValueHitQueue<FieldValueHitQueue.Entry> queue = FieldValueHitQueue.create(this.sort.getSort(), this.numHits);
        if (this.after == null) {
            if (queue.comparators.length == 1) {
                queue.comparators[0].setSingleSort();
            }
            collector = new TopFieldCollector.SimpleFieldCollector(this.sort, queue, this.numHits, this.hitsThresholdChecker, this.minScoreAcc);
        } else {
            if (this.after.fields == null) {
                throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
            }
            if (this.after.fields.length != this.sort.getSort().length) {
                throw new IllegalArgumentException("after.fields has " + this.after.fields.length + " values but sort has " + this.sort.getSort().length);
            }
            collector = new TopFieldCollector.PagingFieldCollector(this.sort, queue, this.after, this.numHits, this.hitsThresholdChecker, this.minScoreAcc);
        }
        this.collectors.add(collector);
        return collector;
    }

    @Override
    public TopFieldDocs reduce(Collection<TopFieldCollector> collectors) throws IOException {
        TopFieldDocs[] topDocs = new TopFieldDocs[collectors.size()];
        int i = 0;
        for (TopFieldCollector collector : collectors) {
            topDocs[i++] = collector.topDocs();
        }
        return TopDocs.merge(this.sort, 0, this.numHits, topDocs);
    }

    public List<TopFieldCollector> getCollectors() {
        return this.collectors;
    }
}

