/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;

abstract class VectorScorer {
    protected final VectorSimilarityFunction similarity;

    static FloatVectorScorer create(LeafReaderContext context, FieldInfo fi, float[] query) throws IOException {
        FloatVectorValues values = context.reader().getFloatVectorValues(fi.name);
        VectorSimilarityFunction similarity = fi.getVectorSimilarityFunction();
        return new FloatVectorScorer(values, query, similarity);
    }

    static ByteVectorScorer create(LeafReaderContext context, FieldInfo fi, byte[] query) throws IOException {
        ByteVectorValues values = context.reader().getByteVectorValues(fi.name);
        VectorSimilarityFunction similarity = fi.getVectorSimilarityFunction();
        return new ByteVectorScorer(values, query, similarity);
    }

    VectorScorer(VectorSimilarityFunction similarity) {
        this.similarity = similarity;
    }

    abstract float score() throws IOException;

    abstract boolean advanceExact(int var1) throws IOException;

    private static class FloatVectorScorer
    extends VectorScorer {
        private final float[] query;
        private final FloatVectorValues values;

        protected FloatVectorScorer(FloatVectorValues values, float[] query, VectorSimilarityFunction similarity) {
            super(similarity);
            this.query = query;
            this.values = values;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            int vectorDoc = this.values.docID();
            if (vectorDoc < doc) {
                vectorDoc = this.values.advance(doc);
            }
            return vectorDoc == doc;
        }

        @Override
        public float score() throws IOException {
            assert (this.values.docID() != -1) : this.getClass().getSimpleName() + " is not positioned";
            return this.similarity.compare(this.query, this.values.vectorValue());
        }
    }

    private static class ByteVectorScorer
    extends VectorScorer {
        private final byte[] query;
        private final ByteVectorValues values;

        protected ByteVectorScorer(ByteVectorValues values, byte[] query, VectorSimilarityFunction similarity) {
            super(similarity);
            this.values = values;
            this.query = query;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            int vectorDoc = this.values.docID();
            if (vectorDoc < doc) {
                vectorDoc = this.values.advance(doc);
            }
            return vectorDoc == doc;
        }

        @Override
        public float score() throws IOException {
            assert (this.values.docID() != -1) : this.getClass().getSimpleName() + " is not positioned";
            return this.similarity.compare(this.query, this.values.vectorValue());
        }
    }
}

