/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.join;

import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.AbstractKnnCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;

class DiversifyingNearestChildrenKnnCollector
extends AbstractKnnCollector {
    private final BitSet parentBitSet;
    private final NodeIdCachingHeap heap;

    public DiversifyingNearestChildrenKnnCollector(int k, int visitLimit, BitSet parentBitSet) {
        super(k, visitLimit);
        this.parentBitSet = parentBitSet;
        this.heap = new NodeIdCachingHeap(k);
    }

    @Override
    public boolean collect(int docId, float nodeScore) {
        assert (!this.parentBitSet.get(docId));
        int parentNode = this.parentBitSet.nextSetBit(docId);
        return this.heap.insertWithOverflow(docId, parentNode, nodeScore);
    }

    @Override
    public float minCompetitiveSimilarity() {
        return this.heap.size >= this.k() ? this.heap.topScore() : Float.NEGATIVE_INFINITY;
    }

    public String toString() {
        return "ToParentJoinKnnCollector[k=" + this.k() + ", size=" + this.heap.size() + "]";
    }

    @Override
    public TopDocs topDocs() {
        assert (this.heap.size() <= this.k()) : "Tried to collect more results than the maximum number allowed";
        while (this.heap.size() > this.k()) {
            this.heap.popToDrain();
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[this.heap.size()];
        for (int i = 1; i <= scoreDocs.length; ++i) {
            scoreDocs[scoreDocs.length - i] = new ScoreDoc(this.heap.topNode(), this.heap.topScore());
            this.heap.popToDrain();
        }
        TotalHits.Relation relation = this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TopDocs(new TotalHits(this.visitedCount(), relation), scoreDocs);
    }

    private static class ParentChildScore
    implements Comparable<ParentChildScore> {
        private final int parent;
        private final int child;
        private final float score;

        ParentChildScore(int child, int parent, float score) {
            this.child = child;
            this.parent = parent;
            this.score = score;
        }

        @Override
        public int compareTo(ParentChildScore o) {
            int fc = Float.compare(this.score, o.score);
            if (fc == 0) {
                return Integer.compare(o.child, this.child);
            }
            return fc;
        }
    }

    private static class NodeIdCachingHeap {
        private final int maxSize;
        private ParentChildScore[] heapNodes;
        private int size = 0;
        private final Map<Integer, Integer> nodeIdHeapIndex;
        private boolean closed = false;

        public NodeIdCachingHeap(int maxSize) {
            if (maxSize < 1 || maxSize >= ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalArgumentException("maxSize must be > 0 and < " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + maxSize);
            }
            int heapSize = maxSize + 1;
            this.maxSize = maxSize;
            this.nodeIdHeapIndex = new HashMap<Integer, Integer>(maxSize < 2 ? maxSize + 1 : (int)((double)maxSize / 0.75 + 1.0));
            this.heapNodes = new ParentChildScore[heapSize];
        }

        public final int topNode() {
            return this.heapNodes[1].child;
        }

        public final float topScore() {
            return this.heapNodes[1].score;
        }

        private void pushIn(int nodeId, int parentId, float score) {
            ++this.size;
            if (this.size == this.heapNodes.length) {
                this.heapNodes = ArrayUtil.grow(this.heapNodes, (this.size * 3 + 1) / 2);
            }
            this.heapNodes[this.size] = new ParentChildScore(nodeId, parentId, score);
            this.upHeap(this.size);
        }

        private void updateElement(int heapIndex, int nodeId, int parentId, float score) {
            ParentChildScore oldValue = this.heapNodes[heapIndex];
            assert (oldValue.parent == parentId) : "attempted to update heap element value but with a different node id";
            float oldScore = this.heapNodes[heapIndex].score;
            this.heapNodes[heapIndex] = new ParentChildScore(nodeId, parentId, score);
            if (score < oldScore) {
                this.upHeap(heapIndex);
            } else {
                this.downHeap(heapIndex);
            }
        }

        public boolean insertWithOverflow(int node, int parentNode, float score) {
            if (this.closed) {
                throw new IllegalStateException();
            }
            Integer previousNodeIndex = this.nodeIdHeapIndex.get(parentNode);
            if (previousNodeIndex != null) {
                if (this.heapNodes[previousNodeIndex.intValue()].score < score) {
                    this.updateElement(previousNodeIndex, node, parentNode, score);
                    return true;
                }
                return false;
            }
            if (this.size >= this.maxSize) {
                if (score < this.heapNodes[1].score || score == this.heapNodes[1].score && node > this.heapNodes[1].child) {
                    return false;
                }
                this.updateTop(node, parentNode, score);
                return true;
            }
            this.pushIn(node, parentNode, score);
            return true;
        }

        private void popToDrain() {
            this.closed = true;
            if (this.size > 0) {
                this.heapNodes[1] = this.heapNodes[this.size];
                --this.size;
            } else {
                throw new IllegalStateException("The heap is empty");
            }
            this.downHeapWithoutCacheUpdate(1);
        }

        private void updateTop(int nodeId, int parentId, float score) {
            this.nodeIdHeapIndex.remove(this.heapNodes[1].parent);
            this.heapNodes[1] = new ParentChildScore(nodeId, parentId, score);
            this.downHeap(1);
        }

        public final int size() {
            return this.size;
        }

        private void upHeap(int origPos) {
            int i = origPos;
            ParentChildScore bottomNode = this.heapNodes[i];
            for (int j = i >>> 1; j > 0 && bottomNode.compareTo(this.heapNodes[j]) < 0; j >>>= 1) {
                this.heapNodes[i] = this.heapNodes[j];
                this.nodeIdHeapIndex.put(this.heapNodes[i].parent, i);
                i = j;
            }
            this.nodeIdHeapIndex.put(bottomNode.parent, i);
            this.heapNodes[i] = bottomNode;
        }

        private int downHeap(int i) {
            ParentChildScore node = this.heapNodes[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.heapNodes[k].compareTo(this.heapNodes[j]) < 0) {
                j = k;
            }
            while (j <= this.size && this.heapNodes[j].compareTo(node) < 0) {
                this.heapNodes[i] = this.heapNodes[j];
                this.nodeIdHeapIndex.put(this.heapNodes[i].parent, i);
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || this.heapNodes[k].compareTo(this.heapNodes[j]) >= 0) continue;
                j = k;
            }
            this.nodeIdHeapIndex.put(node.parent, i);
            this.heapNodes[i] = node;
            return i;
        }

        private int downHeapWithoutCacheUpdate(int i) {
            ParentChildScore node = this.heapNodes[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.heapNodes[k].compareTo(this.heapNodes[j]) < 0) {
                j = k;
            }
            while (j <= this.size && this.heapNodes[j].compareTo(node) < 0) {
                this.heapNodes[i] = this.heapNodes[j];
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || this.heapNodes[k].compareTo(this.heapNodes[j]) >= 0) continue;
                j = k;
            }
            this.heapNodes[i] = node;
            return i;
        }
    }
}

