/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.knn;

import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopKnnCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.BlockingFloatHeap;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.FloatHeap;

public final class MultiLeafTopKnnCollector
extends TopKnnCollector {
    private static final float DEFAULT_GREEDINESS = 0.9f;
    private final BlockingFloatHeap globalSimilarityQueue;
    private final FloatHeap nonCompetitiveQueue;
    private final float greediness;
    private final FloatHeap updatesQueue;
    private final int interval = 255;
    private boolean kResultsCollected = false;
    private float cachedGlobalMinSim = Float.NEGATIVE_INFINITY;

    public MultiLeafTopKnnCollector(int k, int visitLimit, BlockingFloatHeap globalSimilarityQueue) {
        super(k, visitLimit);
        this.greediness = 0.9f;
        this.globalSimilarityQueue = globalSimilarityQueue;
        this.nonCompetitiveQueue = new FloatHeap(Math.max(1, Math.round((1.0f - this.greediness) * (float)k)));
        this.updatesQueue = new FloatHeap(k);
    }

    @Override
    public boolean collect(int docId, float similarity) {
        boolean firstKResultsCollected;
        boolean localSimUpdated = this.queue.insertWithOverflow(docId, similarity);
        boolean bl = firstKResultsCollected = !this.kResultsCollected && this.queue.size() == this.k();
        if (firstKResultsCollected) {
            this.kResultsCollected = true;
        }
        this.updatesQueue.offer(similarity);
        boolean globalSimUpdated = this.nonCompetitiveQueue.offer(similarity);
        if (this.kResultsCollected && (firstKResultsCollected || (this.visitedCount & 0xFFL) == 0L)) {
            this.cachedGlobalMinSim = this.globalSimilarityQueue.offer(this.updatesQueue.getHeap());
            this.updatesQueue.clear();
            globalSimUpdated = true;
        }
        return localSimUpdated || globalSimUpdated;
    }

    @Override
    public float minCompetitiveSimilarity() {
        if (!this.kResultsCollected) {
            return Float.NEGATIVE_INFINITY;
        }
        return Math.max(this.queue.topScore(), Math.min(this.nonCompetitiveQueue.peek(), this.cachedGlobalMinSim));
    }

    @Override
    public TopDocs topDocs() {
        assert (this.queue.size() <= this.k()) : "Tried to collect more results than the maximum number allowed";
        ScoreDoc[] scoreDocs = new ScoreDoc[this.queue.size()];
        for (int i = 1; i <= scoreDocs.length; ++i) {
            scoreDocs[scoreDocs.length - i] = new ScoreDoc(this.queue.topNode(), this.queue.topScore());
            this.queue.pop();
        }
        TotalHits.Relation relation = this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TopDocs(new TotalHits(this.visitedCount(), relation), scoreDocs);
    }

    @Override
    public String toString() {
        return "MultiLeafTopKnnCollector[k=" + this.k() + ", size=" + this.queue.size() + "]";
    }
}

