/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoAreaShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBaseMembershipShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;

abstract class GeoBaseAreaShape
extends GeoBaseMembershipShape
implements GeoAreaShape {
    protected static final int ALL_INSIDE = 0;
    protected static final int SOME_INSIDE = 1;
    protected static final int NONE_INSIDE = 2;

    public GeoBaseAreaShape(PlanetModel planetModel) {
        super(planetModel);
    }

    protected int isShapeInsideGeoAreaShape(GeoShape geoShape) {
        boolean foundOutside = false;
        boolean foundInside = false;
        for (GeoPoint p : geoShape.getEdgePoints()) {
            if (this.isWithin(p)) {
                foundInside = true;
            } else {
                foundOutside = true;
            }
            if (!foundInside || !foundOutside) continue;
            return 1;
        }
        if (!foundInside && !foundOutside) {
            return 2;
        }
        if (foundInside && !foundOutside) {
            return 0;
        }
        if (foundOutside && !foundInside) {
            return 2;
        }
        return 1;
    }

    protected int isGeoAreaShapeInsideShape(GeoShape geoshape) {
        boolean foundOutside = false;
        boolean foundInside = false;
        for (GeoPoint p : this.getEdgePoints()) {
            if (geoshape.isWithin(p)) {
                foundInside = true;
            } else {
                foundOutside = true;
            }
            if (!foundInside || !foundOutside) continue;
            return 1;
        }
        if (!foundInside && !foundOutside) {
            return 2;
        }
        if (foundInside && !foundOutside) {
            return 0;
        }
        if (foundOutside && !foundInside) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getRelationship(GeoShape geoShape) {
        if (!geoShape.getPlanetModel().equals(this.planetModel)) {
            throw new IllegalArgumentException("Cannot relate shapes with different planet models.");
        }
        int insideGeoAreaShape = this.isShapeInsideGeoAreaShape(geoShape);
        if (insideGeoAreaShape == 1) {
            return 2;
        }
        int insideShape = this.isGeoAreaShapeInsideShape(geoShape);
        if (insideShape == 1) {
            return 2;
        }
        if (insideGeoAreaShape == 0 && insideShape == 0) {
            return 2;
        }
        if (this.intersects(geoShape)) {
            return 2;
        }
        if (insideGeoAreaShape == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }
}

