/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.HnswGraphProvider;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.KnnVectorsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergeState;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.InfoStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraph;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraphMerger;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.InitializedHnswGraphBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hppc.IntIntHashMap;

public class IncrementalHnswGraphMerger
implements HnswGraphMerger {
    protected final FieldInfo fieldInfo;
    protected final RandomVectorScorerSupplier scorerSupplier;
    protected final int M;
    protected final int beamWidth;
    protected KnnVectorsReader initReader;
    protected MergeState.DocMap initDocMap;
    protected int initGraphSize;

    public IncrementalHnswGraphMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth) {
        this.fieldInfo = fieldInfo;
        this.scorerSupplier = scorerSupplier;
        this.M = M;
        this.beamWidth = beamWidth;
    }

    @Override
    public IncrementalHnswGraphMerger addReader(KnnVectorsReader reader, MergeState.DocMap docMap, Bits liveDocs) throws IOException {
        KnnVectorsReader currKnnVectorsReader = reader;
        if (reader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            currKnnVectorsReader = ((PerFieldKnnVectorsFormat.FieldsReader)reader).getFieldReader(this.fieldInfo.name);
        }
        if (!(currKnnVectorsReader instanceof HnswGraphProvider) || !IncrementalHnswGraphMerger.noDeletes(liveDocs)) {
            return this;
        }
        int candidateVectorCount = 0;
        switch (this.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                ByteVectorValues byteVectorValues = currKnnVectorsReader.getByteVectorValues(this.fieldInfo.name);
                if (byteVectorValues == null) {
                    return this;
                }
                candidateVectorCount = byteVectorValues.size();
                break;
            }
            case FLOAT32: {
                FloatVectorValues vectorValues = currKnnVectorsReader.getFloatVectorValues(this.fieldInfo.name);
                if (vectorValues == null) {
                    return this;
                }
                candidateVectorCount = vectorValues.size();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected vector encoding: " + this.fieldInfo.getVectorEncoding());
            }
        }
        if (candidateVectorCount > this.initGraphSize) {
            this.initReader = currKnnVectorsReader;
            this.initDocMap = docMap;
            this.initGraphSize = candidateVectorCount;
        }
        return this;
    }

    protected HnswBuilder createBuilder(DocIdSetIterator mergedVectorIterator, int maxOrd) throws IOException {
        if (this.initReader == null) {
            return HnswGraphBuilder.create(this.scorerSupplier, this.M, this.beamWidth, HnswGraphBuilder.randSeed, maxOrd);
        }
        HnswGraph initializerGraph = ((HnswGraphProvider)((Object)this.initReader)).getGraph(this.fieldInfo.name);
        FixedBitSet initializedNodes = new FixedBitSet(maxOrd);
        int[] oldToNewOrdinalMap = this.getNewOrdMapping(mergedVectorIterator, initializedNodes);
        return InitializedHnswGraphBuilder.fromGraph(this.scorerSupplier, this.M, this.beamWidth, HnswGraphBuilder.randSeed, initializerGraph, oldToNewOrdinalMap, initializedNodes, maxOrd);
    }

    @Override
    public OnHeapHnswGraph merge(DocIdSetIterator mergedVectorIterator, InfoStream infoStream, int maxOrd) throws IOException {
        HnswBuilder builder = this.createBuilder(mergedVectorIterator, maxOrd);
        builder.setInfoStream(infoStream);
        return builder.build(maxOrd);
    }

    protected final int[] getNewOrdMapping(DocIdSetIterator mergedVectorIterator, BitSet initializedNodes) throws IOException {
        DocIdSetIterator initializerIterator = null;
        switch (this.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                initializerIterator = this.initReader.getByteVectorValues(this.fieldInfo.name);
                break;
            }
            case FLOAT32: {
                initializerIterator = this.initReader.getFloatVectorValues(this.fieldInfo.name);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected vector encoding: " + this.fieldInfo.getVectorEncoding());
            }
        }
        IntIntHashMap newIdToOldOrdinal = new IntIntHashMap(this.initGraphSize);
        int oldOrd = 0;
        int maxNewDocID = -1;
        int oldId = initializerIterator.nextDoc();
        while (oldId != Integer.MAX_VALUE) {
            int newId = this.initDocMap.get(oldId);
            maxNewDocID = Math.max(newId, maxNewDocID);
            newIdToOldOrdinal.put(newId, oldOrd);
            ++oldOrd;
            oldId = initializerIterator.nextDoc();
        }
        if (maxNewDocID == -1) {
            return new int[0];
        }
        int[] oldToNewOrdinalMap = new int[this.initGraphSize];
        int newOrd = 0;
        int newDocId = mergedVectorIterator.nextDoc();
        while (newDocId <= maxNewDocID) {
            int hashDocIndex = newIdToOldOrdinal.indexOf(newDocId);
            if (newIdToOldOrdinal.indexExists(hashDocIndex)) {
                initializedNodes.set(newOrd);
                oldToNewOrdinalMap[newIdToOldOrdinal.indexGet((int)hashDocIndex)] = newOrd;
            }
            ++newOrd;
            newDocId = mergedVectorIterator.nextDoc();
        }
        return oldToNewOrdinalMap;
    }

    private static boolean noDeletes(Bits liveDocs) {
        if (liveDocs == null) {
            return true;
        }
        for (int i = 0; i < liveDocs.length(); ++i) {
            if (liveDocs.get(i)) continue;
            return false;
        }
        return true;
    }
}

