/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import org.graylog.shaded.opensearch2.org.apache.lucene.search.KnnCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.IntToIntFunction;

public final class OrdinalTranslatedKnnCollector
implements KnnCollector {
    private final KnnCollector in;
    private final IntToIntFunction vectorOrdinalToDocId;

    public OrdinalTranslatedKnnCollector(KnnCollector in, IntToIntFunction vectorOrdinalToDocId) {
        this.in = in;
        this.vectorOrdinalToDocId = vectorOrdinalToDocId;
    }

    @Override
    public boolean earlyTerminated() {
        return this.in.earlyTerminated();
    }

    @Override
    public void incVisitedCount(int count) {
        this.in.incVisitedCount(count);
    }

    @Override
    public long visitedCount() {
        return this.in.visitedCount();
    }

    @Override
    public long visitLimit() {
        return this.in.visitLimit();
    }

    @Override
    public int k() {
        return this.in.k();
    }

    @Override
    public boolean collect(int vectorId, float similarity) {
        return this.in.collect(this.vectorOrdinalToDocId.apply(vectorId), similarity);
    }

    @Override
    public float minCompetitiveSimilarity() {
        return this.in.minCompetitiveSimilarity();
    }

    @Override
    public TopDocs topDocs() {
        TopDocs td = this.in.topDocs();
        return new TopDocs(new TotalHits(this.visitedCount(), this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO), td.scoreDocs);
    }
}

