/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.remotestore.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="2.2.0")
public class RestoreRemoteStoreRequest
extends ClusterManagerNodeRequest<RestoreRemoteStoreRequest>
implements ToXContentObject {
    private String[] indices = Strings.EMPTY_ARRAY;
    private Boolean waitForCompletion = false;
    private Boolean restoreAllShards = false;

    public RestoreRemoteStoreRequest() {
    }

    public RestoreRemoteStoreRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.waitForCompletion = in.readOptionalBoolean();
        this.restoreAllShards = in.readOptionalBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeOptionalBoolean(this.waitForCompletion);
        out.writeOptionalBoolean(this.restoreAllShards);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null || this.indices.length == 0) {
            validationException = ValidateActions.addValidationError("indices are missing", validationException);
        }
        return validationException;
    }

    public RestoreRemoteStoreRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public RestoreRemoteStoreRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[indices.size()]);
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public RestoreRemoteStoreRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public RestoreRemoteStoreRequest restoreAllShards(boolean restoreAllShards) {
        this.restoreAllShards = restoreAllShards;
        return this;
    }

    public boolean restoreAllShards() {
        return this.restoreAllShards;
    }

    public RestoreRemoteStoreRequest source(Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("indices")) {
                if (entry.getValue() instanceof String) {
                    this.indices(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof ArrayList) {
                    this.indices((ArrayList)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed indices section, should be an array of strings");
            }
            if (IndicesOptions.isIndicesOptions(name)) continue;
            throw new IllegalArgumentException("Unknown parameter " + name);
        }
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("indices");
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public String getDescription() {
        return "remote_store";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreRemoteStoreRequest that = (RestoreRemoteStoreRequest)o;
        return this.waitForCompletion == that.waitForCompletion && this.restoreAllShards == that.restoreAllShards && Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        int result = Objects.hash(this.waitForCompletion, this.restoreAllShards);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }
}

