/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards.routing.weighted.put;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.WeightedRoutingService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportAddWeightedRoutingAction
extends TransportClusterManagerNodeAction<ClusterPutWeightedRoutingRequest, ClusterPutWeightedRoutingResponse> {
    private final WeightedRoutingService weightedRoutingService;

    @Inject
    public TransportAddWeightedRoutingAction(TransportService transportService, ClusterService clusterService, WeightedRoutingService weightedRoutingService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/routing/awareness/weights/put", transportService, clusterService, threadPool, actionFilters, ClusterPutWeightedRoutingRequest::new, indexNameExpressionResolver);
        this.weightedRoutingService = weightedRoutingService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterPutWeightedRoutingResponse read(StreamInput in) throws IOException {
        return new ClusterPutWeightedRoutingResponse(in);
    }

    @Override
    protected void clusterManagerOperation(ClusterPutWeightedRoutingRequest request, ClusterState state, ActionListener<ClusterPutWeightedRoutingResponse> listener) throws Exception {
        try {
            this.weightedRoutingService.verifyAwarenessAttribute(request.getWeightedRouting().attributeName());
        }
        catch (ActionRequestValidationException ex) {
            listener.onFailure(ex);
            return;
        }
        this.weightedRoutingService.registerWeightedRoutingMetadata(request, ActionListener.delegateFailure(listener, (delegatedListener, response) -> delegatedListener.onResponse(new ClusterPutWeightedRoutingResponse(response.isAcknowledged()))));
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterPutWeightedRoutingRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

