/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MappingMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class GetIndexResponse
extends ActionResponse
implements ToXContentObject {
    private Map<String, MappingMetadata> mappings = Map.of();
    private Map<String, List<AliasMetadata>> aliases = Map.of();
    private Map<String, Settings> settings = Map.of();
    private Map<String, Settings> defaultSettings = Map.of();
    private Map<String, String> dataStreams = Map.of();
    private final String[] indices;

    public GetIndexResponse(String[] indices, Map<String, MappingMetadata> mappings, Map<String, List<AliasMetadata>> aliases, Map<String, Settings> settings, Map<String, Settings> defaultSettings, Map<String, String> dataStreams) {
        this.indices = indices;
        Arrays.sort(indices);
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = Collections.unmodifiableMap(aliases);
        }
        if (settings != null) {
            this.settings = Collections.unmodifiableMap(settings);
        }
        if (defaultSettings != null) {
            this.defaultSettings = Collections.unmodifiableMap(defaultSettings);
        }
        if (dataStreams != null) {
            this.dataStreams = Collections.unmodifiableMap(dataStreams);
        }
    }

    GetIndexResponse(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        int mappingsSize = in.readVInt();
        HashMap<String, MappingMetadata> mappingsMapBuilder = new HashMap<String, MappingMetadata>();
        for (int i = 0; i < mappingsSize; ++i) {
            String index = in.readString();
            if (in.getVersion().before(Version.V_2_0_0)) {
                int numMappings = in.readVInt();
                if (numMappings == 0) {
                    mappingsMapBuilder.put(index, MappingMetadata.EMPTY_MAPPINGS);
                    continue;
                }
                if (numMappings == 1) {
                    String type = in.readString();
                    if (!"_doc".equals(type)) {
                        throw new IllegalStateException("Expected _doc but got [" + type + "]");
                    }
                    mappingsMapBuilder.put(index, new MappingMetadata(in));
                    continue;
                }
                throw new IllegalStateException("Expected 0 or 1 mappings but got: " + numMappings);
            }
            MappingMetadata metadata = in.readOptionalWriteable(MappingMetadata::new);
            mappingsMapBuilder.put(index, metadata != null ? metadata : MappingMetadata.EMPTY_MAPPINGS);
        }
        this.mappings = Collections.unmodifiableMap(mappingsMapBuilder);
        int aliasesSize = in.readVInt();
        HashMap aliasesMapBuilder = new HashMap();
        for (int i = 0; i < aliasesSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<AliasMetadata> aliasEntryBuilder = new ArrayList<AliasMetadata>(valueSize);
            for (int j = 0; j < valueSize; ++j) {
                aliasEntryBuilder.add(new AliasMetadata(in));
            }
            aliasesMapBuilder.put(key, Collections.unmodifiableList(aliasEntryBuilder));
        }
        this.aliases = Collections.unmodifiableMap(aliasesMapBuilder);
        int settingsSize = in.readVInt();
        HashMap<String, Settings> settingsMapBuilder = new HashMap<String, Settings>();
        for (int i = 0; i < settingsSize; ++i) {
            String key = in.readString();
            settingsMapBuilder.put(key, Settings.readSettingsFromStream(in));
        }
        this.settings = Collections.unmodifiableMap(settingsMapBuilder);
        HashMap<String, Settings> defaultSettingsMapBuilder = new HashMap<String, Settings>();
        int defaultSettingsSize = in.readVInt();
        for (int i = 0; i < defaultSettingsSize; ++i) {
            defaultSettingsMapBuilder.put(in.readString(), Settings.readSettingsFromStream(in));
        }
        this.defaultSettings = Collections.unmodifiableMap(defaultSettingsMapBuilder);
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_8_0)) {
            HashMap<String, String> dataStreamsMapBuilder = new HashMap<String, String>();
            int dataStreamsSize = in.readVInt();
            for (int i = 0; i < dataStreamsSize; ++i) {
                dataStreamsMapBuilder.put(in.readString(), in.readOptionalString());
            }
            this.dataStreams = Collections.unmodifiableMap(dataStreamsMapBuilder);
        }
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] getIndices() {
        return this.indices();
    }

    public Map<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public Map<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    public Map<String, List<AliasMetadata>> aliases() {
        return this.aliases;
    }

    public Map<String, List<AliasMetadata>> getAliases() {
        return this.aliases();
    }

    public Map<String, Settings> settings() {
        return this.settings;
    }

    public Map<String, String> dataStreams() {
        return this.dataStreams;
    }

    public Map<String, String> getDataStreams() {
        return this.dataStreams();
    }

    public Map<String, Settings> defaultSettings() {
        return this.defaultSettings;
    }

    public Map<String, Settings> getSettings() {
        return this.settings();
    }

    public String getSetting(String index, String setting) {
        Settings indexSettings = this.settings.get(index);
        if (setting != null) {
            if (indexSettings != null && indexSettings.hasValue(setting)) {
                return indexSettings.get(setting);
            }
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null) {
                return defaultIndexSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, MappingMetadata> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            if (out.getVersion().before(Version.V_2_0_0)) {
                out.writeVInt(entry.getValue() == MappingMetadata.EMPTY_MAPPINGS ? 0 : 1);
                if (entry.getValue() == MappingMetadata.EMPTY_MAPPINGS) continue;
                out.writeString("_doc");
                entry.getValue().writeTo(out);
                continue;
            }
            out.writeOptionalWriteable(entry.getValue());
        }
        out.writeVInt(this.aliases.size());
        for (Map.Entry<String, Object> entry : this.aliases.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(((List)entry.getValue()).size());
            for (AliasMetadata aliasEntry : (List)entry.getValue()) {
                aliasEntry.writeTo(out);
            }
        }
        out.writeVInt(this.settings.size());
        for (Map.Entry<String, Object> entry : this.settings.entrySet()) {
            out.writeString(entry.getKey());
            Settings.writeSettingsToStream((Settings)entry.getValue(), out);
        }
        out.writeVInt(this.defaultSettings.size());
        for (Map.Entry<String, Object> entry : this.defaultSettings.entrySet()) {
            out.writeString(entry.getKey());
            Settings.writeSettingsToStream((Settings)entry.getValue(), out);
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_8_0)) {
            out.writeVInt(this.dataStreams.size());
            for (Map.Entry<String, Object> entry : this.dataStreams.entrySet()) {
                out.writeString(entry.getKey());
                out.writeOptionalString((String)entry.getValue());
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (String index : this.indices) {
            String dataStream;
            builder.startObject(index);
            builder.startObject("aliases");
            List<AliasMetadata> indexAliases = this.aliases.get(index);
            if (indexAliases != null) {
                for (AliasMetadata alias : indexAliases) {
                    AliasMetadata.Builder.toXContent(alias, builder, params);
                }
            }
            builder.endObject();
            MappingMetadata indexMappings = this.mappings.get(index);
            if (indexMappings == null) {
                builder.startObject("mappings").endObject();
            } else {
                builder.field("mappings", indexMappings.sourceAsMap());
            }
            builder.startObject("settings");
            Settings indexSettings = this.settings.get(index);
            if (indexSettings != null) {
                indexSettings.toXContent(builder, params);
            }
            builder.endObject();
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null && !defaultIndexSettings.isEmpty()) {
                builder.startObject("defaults");
                defaultIndexSettings.toXContent(builder, params);
                builder.endObject();
            }
            if ((dataStream = this.dataStreams.get(index)) != null) {
                builder.field("data_stream", dataStream);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetIndexResponse that = (GetIndexResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.settings, that.settings) && Objects.equals(this.defaultSettings, that.defaultSettings) && Objects.equals(this.dataStreams, that.dataStreams);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.aliases, this.mappings, this.settings, this.defaultSettings, this.dataStreams);
    }
}

