/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.io.JsonStringEncoder;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestOperationsListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.Loggers;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.OpenSearchLogMessage;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.SlowLogLevel;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;

public final class SearchRequestSlowLog
extends SearchRequestOperationsListener {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private long warnThreshold;
    private long infoThreshold;
    private long debugThreshold;
    private long traceThreshold;
    private SlowLogLevel level;
    private final Logger logger;
    static final String CLUSTER_SEARCH_REQUEST_SLOWLOG_PREFIX = "cluster.search.request.slowlog";
    public static final Setting<TimeValue> CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_WARN_SETTING = Setting.timeSetting("cluster.search.request.slowlog.threshold.warn", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_INFO_SETTING = Setting.timeSetting("cluster.search.request.slowlog.threshold.info", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_DEBUG_SETTING = Setting.timeSetting("cluster.search.request.slowlog.threshold.debug", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_TRACE_SETTING = Setting.timeSetting("cluster.search.request.slowlog.threshold.trace", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<SlowLogLevel> CLUSTER_SEARCH_REQUEST_SLOWLOG_LEVEL = new Setting<SlowLogLevel>("cluster.search.request.slowlog.level", SlowLogLevel.TRACE.name(), SlowLogLevel::parse, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));

    public SearchRequestSlowLog(ClusterService clusterService) {
        this(clusterService, LogManager.getLogger((String)CLUSTER_SEARCH_REQUEST_SLOWLOG_PREFIX));
    }

    SearchRequestSlowLog(ClusterService clusterService, Logger logger) {
        this.logger = logger;
        Loggers.setLevel(this.logger, SlowLogLevel.TRACE.name());
        this.setWarnThreshold(clusterService.getClusterSettings().get(CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_WARN_SETTING));
        this.setInfoThreshold(clusterService.getClusterSettings().get(CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_INFO_SETTING));
        this.setDebugThreshold(clusterService.getClusterSettings().get(CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_DEBUG_SETTING));
        this.setTraceThreshold(clusterService.getClusterSettings().get(CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_TRACE_SETTING));
        this.setLevel(clusterService.getClusterSettings().get(CLUSTER_SEARCH_REQUEST_SLOWLOG_LEVEL));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_WARN_SETTING, this::setWarnThreshold);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_INFO_SETTING, this::setInfoThreshold);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_DEBUG_SETTING, this::setDebugThreshold);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_SEARCH_REQUEST_SLOWLOG_THRESHOLD_TRACE_SETTING, this::setTraceThreshold);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_SEARCH_REQUEST_SLOWLOG_LEVEL, this::setLevel);
    }

    @Override
    protected void onPhaseStart(SearchPhaseContext context) {
    }

    @Override
    protected void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
    }

    @Override
    protected void onPhaseFailure(SearchPhaseContext context, Throwable cause) {
    }

    @Override
    protected void onRequestStart(SearchRequestContext searchRequestContext) {
    }

    @Override
    protected void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        long tookInNanos = System.nanoTime() - searchRequestContext.getAbsoluteStartNanos();
        if (this.warnThreshold >= 0L && tookInNanos > this.warnThreshold && this.level.isLevelEnabledFor(SlowLogLevel.WARN)) {
            this.logger.warn((Message)new SearchRequestSlowLogMessage(context, tookInNanos, searchRequestContext));
        } else if (this.infoThreshold >= 0L && tookInNanos > this.infoThreshold && this.level.isLevelEnabledFor(SlowLogLevel.INFO)) {
            this.logger.info((Message)new SearchRequestSlowLogMessage(context, tookInNanos, searchRequestContext));
        } else if (this.debugThreshold >= 0L && tookInNanos > this.debugThreshold && this.level.isLevelEnabledFor(SlowLogLevel.DEBUG)) {
            this.logger.debug((Message)new SearchRequestSlowLogMessage(context, tookInNanos, searchRequestContext));
        } else if (this.traceThreshold >= 0L && tookInNanos > this.traceThreshold && this.level.isLevelEnabledFor(SlowLogLevel.TRACE)) {
            this.logger.trace((Message)new SearchRequestSlowLogMessage(context, tookInNanos, searchRequestContext));
        }
    }

    void setWarnThreshold(TimeValue warnThreshold) {
        this.warnThreshold = warnThreshold.nanos();
        this.setEnabledIfThresholdExceed();
    }

    void setInfoThreshold(TimeValue infoThreshold) {
        this.infoThreshold = infoThreshold.nanos();
        this.setEnabledIfThresholdExceed();
    }

    void setDebugThreshold(TimeValue debugThreshold) {
        this.debugThreshold = debugThreshold.nanos();
        this.setEnabledIfThresholdExceed();
    }

    void setTraceThreshold(TimeValue traceThreshold) {
        this.traceThreshold = traceThreshold.nanos();
        this.setEnabledIfThresholdExceed();
    }

    void setLevel(SlowLogLevel level) {
        this.level = level;
    }

    protected long getWarnThreshold() {
        return this.warnThreshold;
    }

    protected long getInfoThreshold() {
        return this.infoThreshold;
    }

    protected long getDebugThreshold() {
        return this.debugThreshold;
    }

    protected long getTraceThreshold() {
        return this.traceThreshold;
    }

    SlowLogLevel getLevel() {
        return this.level;
    }

    private void setEnabledIfThresholdExceed() {
        super.setEnabled(this.warnThreshold >= 0L || this.debugThreshold >= 0L || this.infoThreshold >= 0L || this.traceThreshold >= 0L);
    }

    static final class SearchRequestSlowLogMessage
    extends OpenSearchLogMessage {
        SearchRequestSlowLogMessage(SearchPhaseContext context, long tookInNanos, SearchRequestContext searchRequestContext) {
            super(SearchRequestSlowLogMessage.prepareMap(context, tookInNanos, searchRequestContext), SearchRequestSlowLogMessage.message(context, tookInNanos, searchRequestContext), new Object[0]);
        }

        private static Map<String, Object> prepareMap(SearchPhaseContext context, long tookInNanos, SearchRequestContext searchRequestContext) {
            HashMap<String, Object> messageFields = new HashMap<String, Object>();
            messageFields.put("took", TimeValue.timeValueNanos(tookInNanos));
            messageFields.put("took_millis", TimeUnit.NANOSECONDS.toMillis(tookInNanos));
            messageFields.put("phase_took", searchRequestContext.phaseTookMap().toString());
            if (searchRequestContext.totalHits() != null) {
                messageFields.put("total_hits", searchRequestContext.totalHits());
            } else {
                messageFields.put("total_hits", "-1");
            }
            messageFields.put("search_type", (Object)context.getRequest().searchType());
            messageFields.put("shards", searchRequestContext.formattedShardStats());
            if (context.getRequest().source() != null) {
                String source = SearchRequestSlowLogMessage.escapeJson(context.getRequest().source().toString(FORMAT_PARAMS));
                messageFields.put("source", source);
            } else {
                messageFields.put("source", "{}");
            }
            messageFields.put("id", context.getTask().getHeader("X-Opaque-Id"));
            return messageFields;
        }

        private static String message(SearchPhaseContext context, long tookInNanos, SearchRequestContext searchRequestContext) {
            StringBuilder sb = new StringBuilder();
            sb.append("took[").append(TimeValue.timeValueNanos(tookInNanos)).append("], ");
            sb.append("took_millis[").append(TimeUnit.NANOSECONDS.toMillis(tookInNanos)).append("], ");
            sb.append("phase_took_millis[").append(searchRequestContext.phaseTookMap().toString()).append("], ");
            if (searchRequestContext.totalHits() != null) {
                sb.append("total_hits[").append(searchRequestContext.totalHits()).append("], ");
            } else {
                sb.append("total_hits[-1]");
            }
            sb.append("search_type[").append((Object)context.getRequest().searchType()).append("], ");
            sb.append("shards[").append(searchRequestContext.formattedShardStats()).append("], ");
            if (context.getRequest().source() != null) {
                sb.append("source[").append(context.getRequest().source().toString(FORMAT_PARAMS)).append("], ");
            } else {
                sb.append("source[], ");
            }
            if (context.getTask().getHeader("X-Opaque-Id") != null) {
                sb.append("id[").append(context.getTask().getHeader("X-Opaque-Id")).append("]");
            } else {
                sb.append("id[]");
            }
            return sb.toString();
        }

        private static String escapeJson(String text) {
            byte[] sourceEscaped = JsonStringEncoder.getInstance().quoteAsUTF8(text);
            return new String(sourceEscaped, UTF_8);
        }
    }
}

