/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ShardSearchContextId;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;

public class UpdatePitContextRequest
extends TransportRequest {
    private final String pitId;
    private final long keepAlive;
    private final long creationTime;
    private final ShardSearchContextId searchContextId;

    public UpdatePitContextRequest(ShardSearchContextId searchContextId, String pitId, long keepAlive, long creationTime) {
        this.pitId = pitId;
        this.searchContextId = searchContextId;
        this.keepAlive = keepAlive;
        this.creationTime = creationTime;
    }

    UpdatePitContextRequest(StreamInput in) throws IOException {
        super(in);
        this.pitId = in.readString();
        this.keepAlive = in.readLong();
        this.creationTime = in.readLong();
        this.searchContextId = new ShardSearchContextId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.pitId);
        out.writeLong(this.keepAlive);
        out.writeLong(this.creationTime);
        this.searchContextId.writeTo(out);
    }

    public ShardSearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    public String getPitId() {
        return this.pitId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }
}

