/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListenerResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BackoffPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.HandledTransportAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.RetryableAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.term.GetTermVersionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.term.GetTermVersionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterManagerNodeChangePredicate;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateObserver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.NotClusterManagerException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.FailedToCommitClusterStateException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterManagerThrottlingException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportMessage;
import org.graylog.shaded.opensearch2.org.opensearch.discovery.ClusterManagerNotDiscoveredException;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlActionType;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.ConnectTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public abstract class TransportClusterManagerNodeAction<Request extends ClusterManagerNodeRequest<Request>, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(TransportClusterManagerNodeAction.class);
    protected final ThreadPool threadPool;
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    private final String executor;

    protected TransportClusterManagerNodeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver) {
        this(actionName, true, null, transportService, clusterService, threadPool, actionFilters, request, indexNameExpressionResolver);
    }

    protected TransportClusterManagerNodeAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver) {
        this(actionName, canTripCircuitBreaker, null, transportService, clusterService, threadPool, actionFilters, request, indexNameExpressionResolver);
    }

    protected TransportClusterManagerNodeAction(String actionName, boolean canTripCircuitBreaker, AdmissionControlActionType admissionControlActionType, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(actionName, canTripCircuitBreaker, admissionControlActionType, transportService, actionFilters, request);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.executor = this.executor();
    }

    protected abstract String executor();

    protected abstract Response read(StreamInput var1) throws IOException;

    @Deprecated
    protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        throw new UnsupportedOperationException("Must be overridden");
    }

    protected void clusterManagerOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        this.masterOperation(request, state, listener);
    }

    @Deprecated
    protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        this.clusterManagerOperation(request, state, listener);
    }

    protected void clusterManagerOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        this.masterOperation(task, request, state, listener);
    }

    protected boolean localExecute(Request request) {
        return false;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        if (task != null) {
            request.setParentTask(this.clusterService.localNode().getId(), task.getId());
        }
        new AsyncSingleAction(this, task, request, listener).run();
    }

    protected String getClusterManagerActionName(DiscoveryNode node) {
        return this.actionName;
    }

    @Deprecated
    protected String getMasterActionName(DiscoveryNode node) {
        return this.getClusterManagerActionName(node);
    }

    protected boolean localExecuteSupportedByAction() {
        return false;
    }

    static class AsyncSingleAction
    extends RetryableAction {
        private ActionListener<Response> listener;
        private final Request request;
        private ClusterStateObserver observer;
        private final long startTime;
        private final Task task;
        final /* synthetic */ TransportClusterManagerNodeAction this$0;

        AsyncSingleAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            super(logger, this$0.threadPool, ClusterManagerTaskThrottler.getBaseDelayForRetry(), ((ClusterManagerNodeRequest)request).clusterManagerNodeTimeout, listener, BackoffPolicy.exponentialEqualJitterBackoff(ClusterManagerTaskThrottler.getBaseDelayForRetry().millis(), ClusterManagerTaskThrottler.getMaxDelayForRetry().millis()), "same");
            this.task = task;
            this.request = request;
            this.startTime = this$0.threadPool.relativeTimeInMillis();
        }

        public void tryAction(ActionListener retryListener) {
            ClusterState state = this.this$0.clusterService.state();
            logger.trace("starting processing request [{}] with cluster state version [{}]", this.request, (Object)state.version());
            this.listener = retryListener;
            this.doStart(state);
        }

        @Override
        public boolean shouldRetry(Exception e) {
            if (((TransportMessage)this.request).remoteAddress() == null) {
                if (e instanceof TransportException) {
                    return ((TransportException)e).unwrapCause() instanceof ClusterManagerThrottlingException;
                }
                return e instanceof ClusterManagerThrottlingException;
            }
            return false;
        }

        @Override
        public Exception getTimeoutException(Exception e) {
            return new ProcessClusterEventTimeoutException(((ClusterManagerNodeRequest)this.request).masterNodeTimeout, this.this$0.actionName);
        }

        protected void doStart(ClusterState clusterState) {
            try {
                DiscoveryNodes nodes = clusterState.nodes();
                if (nodes.isLocalNodeElectedClusterManager() || this.this$0.localExecute(this.request)) {
                    ClusterBlockException blockException = this.this$0.checkBlock(this.request, clusterState);
                    if (blockException != null) {
                        if (!blockException.retryable()) {
                            this.listener.onFailure(blockException);
                        } else {
                            logger.debug("can't execute due to a cluster block, retrying", (Throwable)blockException);
                            this.retry(clusterState, blockException, newState -> {
                                try {
                                    ClusterBlockException newException = this.this$0.checkBlock(this.request, (ClusterState)newState);
                                    return newException == null || !newException.retryable();
                                }
                                catch (Exception e) {
                                    logger.trace("exception occurred during cluster block checking, accepting state", (Throwable)e);
                                    return true;
                                }
                            });
                        }
                    } else {
                        this.this$0.threadPool.executor(this.this$0.executor).execute(ActionRunnable.wrap(this.getDelegateForLocalExecute(clusterState), l -> this.this$0.clusterManagerOperation(this.task, this.request, clusterState, l)));
                    }
                } else if (nodes.getClusterManagerNode() == null) {
                    logger.debug("no known cluster-manager node, scheduling a retry");
                    this.retryOnMasterChange(clusterState, null);
                } else {
                    DiscoveryNode clusterManagerNode = nodes.getClusterManagerNode();
                    if (clusterManagerNode.getVersion().onOrAfter(Version.V_2_13_0) && this.this$0.localExecuteSupportedByAction()) {
                        BiConsumer<DiscoveryNode, ClusterState> executeOnLocalOrClusterManager = this.clusterStateLatestChecker(this::executeOnLocalNode, this::executeOnClusterManager);
                        executeOnLocalOrClusterManager.accept(clusterManagerNode, clusterState);
                    } else {
                        this.executeOnClusterManager(clusterManagerNode, clusterState);
                    }
                }
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }

        private void retryOnMasterChange(ClusterState state, Throwable failure) {
            this.retry(state, failure, ClusterManagerNodeChangePredicate.build(state));
        }

        private void retry(ClusterState state, final Throwable failure, Predicate<ClusterState> statePredicate) {
            if (this.observer == null) {
                long remainingTimeoutMS = ((ClusterManagerNodeRequest)this.request).clusterManagerNodeTimeout().millis() - (this.this$0.threadPool.relativeTimeInMillis() - this.startTime);
                if (remainingTimeoutMS <= 0L) {
                    logger.debug(() -> new ParameterizedMessage("timed out before retrying [{}] after failure", (Object)this.this$0.actionName), failure);
                    this.listener.onFailure(new ClusterManagerNotDiscoveredException(failure));
                    return;
                }
                this.observer = new ClusterStateObserver(state, this.this$0.clusterService, TimeValue.timeValueMillis(remainingTimeoutMS), logger, this.this$0.threadPool.getThreadContext());
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart(state);
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    logger.debug(() -> new ParameterizedMessage("timed out while retrying [{}] after failure (timeout [{}])", (Object)AsyncSingleAction.this.this$0.actionName, (Object)timeout), failure);
                    AsyncSingleAction.this.listener.onFailure(new ClusterManagerNotDiscoveredException(failure));
                }
            }, statePredicate);
        }

        private ActionListener<Response> getDelegateForLocalExecute(ClusterState clusterState) {
            return ActionListener.delegateResponse(this.listener, (delegatedListener, t) -> {
                if (t instanceof FailedToCommitClusterStateException || t instanceof NotClusterManagerException) {
                    logger.debug(() -> new ParameterizedMessage("cluster-manager could not publish cluster state or stepped down before publishing action [{}], scheduling a retry", (Object)this.this$0.actionName), (Throwable)t);
                    this.retryOnMasterChange(clusterState, (Throwable)t);
                } else {
                    delegatedListener.onFailure((Exception)t);
                }
            });
        }

        protected BiConsumer<DiscoveryNode, ClusterState> clusterStateLatestChecker(final Consumer<ClusterState> onLatestLocalState, final BiConsumer<DiscoveryNode, ClusterState> onStaleLocalState) {
            return (clusterManagerNode, clusterState) -> this.this$0.transportService.sendRequest((DiscoveryNode)clusterManagerNode, "internal:monitor/term", new GetTermVersionRequest(), new TransportResponseHandler<GetTermVersionResponse>(){

                @Override
                public void handleResponse(GetTermVersionResponse response) {
                    boolean isLatestClusterStatePresentOnLocalNode = response.matches(clusterState);
                    logger.trace("Received GetTermVersionResponse response : ClusterStateTermVersion {}, latest-on-local {}", (Object)response.getClusterStateTermVersion(), (Object)isLatestClusterStatePresentOnLocalNode);
                    if (isLatestClusterStatePresentOnLocalNode) {
                        onLatestLocalState.accept(clusterState);
                    } else {
                        onStaleLocalState.accept(clusterManagerNode, clusterState);
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    AsyncSingleAction.this.handleTransportException(clusterManagerNode, clusterState, exp);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public GetTermVersionResponse read(StreamInput in) throws IOException {
                    return new GetTermVersionResponse(in);
                }
            });
        }

        private void executeOnLocalNode(ClusterState localClusterState) {
            ActionRunnable runTask = ActionRunnable.wrap(this.getDelegateForLocalExecute(localClusterState), l -> this.this$0.clusterManagerOperation(this.task, this.request, localClusterState, l));
            this.this$0.threadPool.executor(this.this$0.executor).execute(runTask);
        }

        private void executeOnClusterManager(final DiscoveryNode clusterManagerNode, final ClusterState clusterState) {
            String actionName = this.this$0.getClusterManagerActionName(clusterManagerNode);
            this.this$0.transportService.sendRequest(clusterManagerNode, actionName, (TransportRequest)this.request, new ActionListenerResponseHandler<Response>(this.listener, this.this$0::read){

                @Override
                public void handleException(TransportException exp) {
                    AsyncSingleAction.this.handleTransportException(clusterManagerNode, clusterState, exp);
                }
            });
        }

        private void handleTransportException(DiscoveryNode clusterManagerNode, ClusterState clusterState, TransportException exp) {
            Throwable cause = exp.unwrapCause();
            if (cause instanceof ConnectTransportException || exp instanceof RemoteTransportException && cause instanceof NodeClosedException) {
                logger.debug("connection exception while trying to forward request with action name [{}] to master node [{}], scheduling a retry. Error: [{}]", (Object)this.this$0.actionName, (Object)clusterManagerNode, (Object)exp.getDetailedMessage());
                this.retryOnMasterChange(clusterState, cause);
            } else {
                this.listener.onFailure(exp);
            }
        }
    }
}

