/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.awarenesshealth;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.WeightedRoutingMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRoutingState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.WeightedRouting;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParserUtils;

@PublicApi(since="1.0.0")
public class ClusterAwarenessAttributeValueHealth
implements Writeable,
ToXContentFragment {
    private static final String ACTIVE_SHARDS = "active_shards";
    private static final String INITIALIZING_SHARDS = "initializing_shards";
    private static final String RELOCATING_SHARDS = "relocating_shards";
    private static final String UNASSIGNED_SHARDS = "unassigned_shards";
    private static final String NODES = "data_nodes";
    private static final String WEIGHTS = "weight";
    private final String name;
    private int activeShards;
    private int unassignedShards;
    private int initializingShards;
    private int relocatingShards;
    private int nodes;
    private double weight;
    private List<String> nodeList;

    public ClusterAwarenessAttributeValueHealth(String name, List<String> nodeList) {
        this.name = name;
        this.nodeList = nodeList;
    }

    ClusterAwarenessAttributeValueHealth(String name, int activeShards, int initializingShards, int relocatingShards, int unassignedShards, int nodes, double weights) {
        this.name = name;
        this.activeShards = activeShards;
        this.initializingShards = initializingShards;
        this.relocatingShards = relocatingShards;
        this.unassignedShards = unassignedShards;
        this.nodes = nodes;
        this.weight = weights;
    }

    public ClusterAwarenessAttributeValueHealth(StreamInput in) throws IOException {
        this.name = in.readString();
        this.activeShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.nodes = in.readVInt();
        this.weight = in.readDouble();
    }

    public static ClusterAwarenessAttributeValueHealth fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        String attributeName = parser.currentName();
        int active_shards = 0;
        int initializing_shards = 0;
        int relocating_shards = 0;
        int unassigned_shards = 0;
        int nodes = 0;
        double weight = 0.0;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String currentFieldName;
                switch (currentFieldName = parser.currentName()) {
                    case "active_shards": {
                        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                            throw new OpenSearchParseException("failed to parse active shards field, expected number but found unknown type", new Object[0]);
                        }
                        active_shards = parser.intValue();
                        break;
                    }
                    case "initializing_shards": {
                        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                            throw new OpenSearchParseException("failed to parse initializing shards field, expected number but found unknown type", new Object[0]);
                        }
                        initializing_shards = parser.intValue();
                        break;
                    }
                    case "relocating_shards": {
                        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                            throw new OpenSearchParseException("failed to parse relocating shards field, expected number but found unknown type", new Object[0]);
                        }
                        relocating_shards = parser.intValue();
                        break;
                    }
                    case "unassigned_shards": {
                        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                            throw new OpenSearchParseException("failed to parse unassigned field, expected number but found unknown type", new Object[0]);
                        }
                        unassigned_shards = parser.intValue();
                        break;
                    }
                    case "data_nodes": {
                        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                            throw new OpenSearchParseException("failed to parse node field, expected number but found unknown type", new Object[0]);
                        }
                        nodes = parser.intValue();
                        break;
                    }
                    case "weight": {
                        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                            throw new OpenSearchParseException("failed to parse weight field, expected number but found unknown type", new Object[0]);
                        }
                        weight = parser.doubleValue();
                    }
                }
                continue;
            }
            throw new OpenSearchParseException("failed to parse awareness attribute health, expected [{}] but found [{}]", new Object[]{XContentParser.Token.FIELD_NAME, token});
        }
        return new ClusterAwarenessAttributeValueHealth(attributeName, active_shards, initializing_shards, relocating_shards, unassigned_shards, nodes, weight);
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public void setActiveShards(int activeShards) {
        this.activeShards = activeShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public void setUnassignedShards(int unassignedShards) {
        this.unassignedShards = unassignedShards;
    }

    public int getNodes() {
        return this.nodes;
    }

    public void setNodes(int nodes) {
        this.nodes = nodes;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String getName() {
        return this.name;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public void setInitializingShards(int initializingShards) {
        this.initializingShards = initializingShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public void setRelocatingShards(int relocatingShards) {
        this.relocatingShards = relocatingShards;
    }

    public List<String> getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(List<String> nodeList) {
        this.nodeList = nodeList;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.unassignedShards);
        out.writeVInt(this.nodes);
        out.writeDouble(this.weight);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.field(NODES, this.getNodes());
        builder.field(WEIGHTS, this.getWeight());
        builder.endObject();
        return builder;
    }

    void computeAttributeValueLevelInfo(ClusterState clusterState, boolean displayUnassignedShardLevelInfo, int shardsPerAttributeValue) {
        this.nodes = this.nodeList.size();
        this.setShardLevelInfo(clusterState, displayUnassignedShardLevelInfo, shardsPerAttributeValue);
        this.setWeightInfo(clusterState);
    }

    private void setShardLevelInfo(ClusterState clusterState, boolean displayUnassignedShardLevelInfo, int shardsPerAttributeValue) {
        for (String nodeId : this.nodeList) {
            RoutingNode node = clusterState.getRoutingNodes().node(nodeId);
            this.activeShards += node.numberOfShardsWithState(ShardRoutingState.STARTED);
            this.relocatingShards += node.numberOfShardsWithState(ShardRoutingState.RELOCATING);
            this.initializingShards += node.numberOfShardsWithState(ShardRoutingState.INITIALIZING);
        }
        if (displayUnassignedShardLevelInfo) {
            int unassignedShardsPerAttribute = shardsPerAttributeValue - this.getActiveShards() - this.getInitializingShards();
            this.setUnassignedShards(unassignedShardsPerAttribute);
        } else {
            this.setUnassignedShards(-1);
        }
    }

    private void setWeightInfo(ClusterState clusterState) {
        WeightedRoutingMetadata weightedRoutingMetadata = clusterState.getMetadata().weightedRoutingMetadata();
        double attributeWeight = 1.0;
        if (weightedRoutingMetadata != null) {
            WeightedRouting weightedRouting = weightedRoutingMetadata.getWeightedRouting();
            attributeWeight = weightedRouting.weights().getOrDefault(this.name, 1.0);
        }
        this.setWeight(attributeWeight);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterAwarenessAttributeValueHealth)) {
            return false;
        }
        ClusterAwarenessAttributeValueHealth that = (ClusterAwarenessAttributeValueHealth)o;
        return this.name.equals(that.name) && this.activeShards == that.activeShards && this.relocatingShards == that.relocatingShards && this.initializingShards == that.initializingShards && this.unassignedShards == that.unassignedShards && this.nodes == that.nodes && this.weight == that.weight;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.activeShards, this.relocatingShards, this.initializingShards, this.unassignedShards, this.nodes, this.weight);
    }
}

