/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common;

import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.opensearch2.org.opensearch.common.MacAddressProvider;
import org.graylog.shaded.opensearch2.org.opensearch.common.SecureRandomHolder;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDGenerator;

class TimeBasedUUIDGenerator
implements UUIDGenerator {
    private final AtomicInteger sequenceNumber = new AtomicInteger(SecureRandomHolder.INSTANCE.nextInt());
    private final AtomicLong lastTimestamp = new AtomicLong(0L);
    private static final byte[] SECURE_MUNGED_ADDRESS = MacAddressProvider.getSecureMungedAddress();

    TimeBasedUUIDGenerator() {
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected byte[] macAddress() {
        return SECURE_MUNGED_ADDRESS;
    }

    @Override
    public String getBase64UUID() {
        int sequenceId = this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        long currentTimeMillis = this.currentTimeMillis();
        long timestamp = this.lastTimestamp.updateAndGet(lastTimestamp -> {
            long nonBackwardsTimestamp = Math.max(lastTimestamp, currentTimeMillis);
            if (sequenceId == 0) {
                ++nonBackwardsTimestamp;
            }
            return nonBackwardsTimestamp;
        });
        byte[] uuidBytes = new byte[15];
        int i = 0;
        uuidBytes[i++] = (byte)sequenceId;
        uuidBytes[i++] = (byte)(sequenceId >>> 16);
        uuidBytes[i++] = (byte)(timestamp >>> 16);
        uuidBytes[i++] = (byte)(timestamp >>> 24);
        uuidBytes[i++] = (byte)(timestamp >>> 32);
        uuidBytes[i++] = (byte)(timestamp >>> 40);
        byte[] macAddress = this.macAddress();
        assert (macAddress.length == 6);
        System.arraycopy(macAddress, 0, uuidBytes, i, macAddress.length);
        i += macAddress.length;
        uuidBytes[i++] = (byte)(timestamp >>> 8);
        uuidBytes[i++] = (byte)(sequenceId >>> 8);
        uuidBytes[i++] = (byte)timestamp;
        assert (i == uuidBytes.length);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(uuidBytes);
    }

    static {
        assert (SECURE_MUNGED_ADDRESS.length == 6);
    }
}

