/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats.CacheStats;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats.CacheStatsHolder;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats.ImmutableCacheStats;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats.ImmutableCacheStatsHolder;

public class DefaultCacheStatsHolder
implements CacheStatsHolder {
    protected final List<String> dimensionNames;
    private final Node statsRoot;
    private final Lock lock = new ReentrantLock();
    private final String storeName;

    public DefaultCacheStatsHolder(List<String> dimensionNames, String storeName) {
        this.dimensionNames = Collections.unmodifiableList(dimensionNames);
        this.storeName = storeName;
        this.statsRoot = new Node("", true);
    }

    public List<String> getDimensionNames() {
        return this.dimensionNames;
    }

    @Override
    public void incrementHits(List<String> dimensionValues) {
        this.internalIncrement(dimensionValues, Node::incrementHits, true);
    }

    @Override
    public void incrementMisses(List<String> dimensionValues) {
        this.internalIncrement(dimensionValues, Node::incrementMisses, true);
    }

    @Override
    public void incrementEvictions(List<String> dimensionValues) {
        this.internalIncrement(dimensionValues, Node::incrementEvictions, true);
    }

    @Override
    public void incrementSizeInBytes(List<String> dimensionValues, long amountBytes) {
        this.internalIncrement(dimensionValues, node -> node.incrementSizeInBytes(amountBytes), true);
    }

    @Override
    public void decrementSizeInBytes(List<String> dimensionValues, long amountBytes) {
        this.internalIncrement(dimensionValues, node -> node.decrementSizeInBytes(amountBytes), false);
    }

    @Override
    public void incrementItems(List<String> dimensionValues) {
        this.internalIncrement(dimensionValues, Node::incrementItems, true);
    }

    @Override
    public void decrementItems(List<String> dimensionValues) {
        this.internalIncrement(dimensionValues, Node::decrementItems, false);
    }

    @Override
    public void reset() {
        this.resetHelper(this.statsRoot);
    }

    private void resetHelper(Node current) {
        current.resetSizeAndEntries();
        for (Node child : current.children.values()) {
            this.resetHelper(child);
        }
    }

    @Override
    public long count() {
        return this.statsRoot.getEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalIncrement(List<String> dimensionValues, Consumer<Node> adder, boolean createNodesIfAbsent) {
        assert (dimensionValues.size() == this.dimensionNames.size());
        boolean didIncrement = this.internalIncrementHelper(dimensionValues, this.statsRoot, 0, adder, false);
        if (!didIncrement && createNodesIfAbsent) {
            try {
                this.lock.lock();
                this.internalIncrementHelper(dimensionValues, this.statsRoot, 0, adder, true);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean internalIncrementHelper(List<String> dimensionValues, Node node, int depth, Consumer<Node> adder, boolean createNodesIfAbsent) {
        if (depth == dimensionValues.size()) {
            adder.accept(node);
            return true;
        }
        Node child = node.getChild(dimensionValues.get(depth));
        if (child == null) {
            if (createNodesIfAbsent) {
                boolean createMapInChild = depth < dimensionValues.size() - 1;
                child = node.createChild(dimensionValues.get(depth), createMapInChild);
            } else {
                return false;
            }
        }
        if (this.internalIncrementHelper(dimensionValues, child, depth + 1, adder, createNodesIfAbsent)) {
            adder.accept(node);
            return true;
        }
        return false;
    }

    @Override
    public ImmutableCacheStatsHolder getImmutableCacheStatsHolder(String[] levels) {
        String[] nonNullLevels = Objects.requireNonNullElseGet(levels, () -> new String[0]);
        return new ImmutableCacheStatsHolder(this.statsRoot, nonNullLevels, this.dimensionNames, this.storeName);
    }

    @Override
    public void removeDimensions(List<String> dimensionValues) {
        assert (dimensionValues.size() == this.dimensionNames.size()) : "Must specify a value for every dimension when removing from StatsHolder";
        this.lock.lock();
        try {
            this.removeDimensionsHelper(dimensionValues, this.statsRoot, 0);
        }
        finally {
            this.lock.unlock();
        }
    }

    private ImmutableCacheStats removeDimensionsHelper(List<String> dimensionValues, Node node, int depth) {
        if (depth == dimensionValues.size()) {
            return node.getImmutableStats();
        }
        Node child = node.getChild(dimensionValues.get(depth));
        if (child == null) {
            return null;
        }
        ImmutableCacheStats statsToDecrement = this.removeDimensionsHelper(dimensionValues, child, depth + 1);
        if (statsToDecrement != null) {
            node.decrementBySnapshot(statsToDecrement);
            if (child.getChildren().isEmpty()) {
                node.children.remove(child.getDimensionValue());
            }
        }
        return statsToDecrement;
    }

    Node getStatsRoot() {
        return this.statsRoot;
    }

    protected static class Node {
        private final String dimensionValue;
        final Map<String, Node> children;
        private CacheStats stats;
        private static final Map<String, Node> EMPTY_CHILDREN_MAP = new HashMap<String, Node>();

        Node(String dimensionValue, boolean createChildrenMap) {
            this.dimensionValue = dimensionValue;
            this.children = createChildrenMap ? new ConcurrentHashMap<String, Node>() : EMPTY_CHILDREN_MAP;
            this.stats = new CacheStats();
        }

        public String getDimensionValue() {
            return this.dimensionValue;
        }

        protected Map<String, Node> getChildren() {
            return this.children;
        }

        public void incrementHits() {
            this.stats.incrementHits();
        }

        public void incrementMisses() {
            this.stats.incrementMisses();
        }

        public void incrementEvictions() {
            this.stats.incrementEvictions();
        }

        public void incrementSizeInBytes(long amountBytes) {
            this.stats.incrementSizeInBytes(amountBytes);
        }

        public void decrementSizeInBytes(long amountBytes) {
            this.stats.decrementSizeInBytes(amountBytes);
        }

        void incrementItems() {
            this.stats.incrementItems();
        }

        void decrementItems() {
            this.stats.decrementItems();
        }

        long getEntries() {
            return this.stats.getItems();
        }

        ImmutableCacheStats getImmutableStats() {
            return this.stats.immutableSnapshot();
        }

        void decrementBySnapshot(ImmutableCacheStats snapshot) {
            this.stats.subtract(snapshot);
        }

        void resetSizeAndEntries() {
            this.stats.resetSizeAndEntries();
        }

        Node getChild(String dimensionValue) {
            return this.children.get(dimensionValue);
        }

        Node createChild(String dimensionValue, boolean createMapInChild) {
            return this.children.computeIfAbsent(dimensionValue, key -> new Node(dimensionValue, createMapInChild));
        }

        public boolean isAtLowestLevel() {
            return this.children == EMPTY_CHILDREN_MAP;
        }
    }
}

