/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class ImmutableCacheStats
implements Writeable,
ToXContent {
    private final long hits;
    private final long misses;
    private final long evictions;
    private final long sizeInBytes;
    private final long items;

    public ImmutableCacheStats(long hits, long misses, long evictions, long sizeInBytes, long items) {
        this.hits = hits;
        this.misses = misses;
        this.evictions = evictions;
        this.sizeInBytes = sizeInBytes;
        this.items = items;
    }

    public ImmutableCacheStats(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
    }

    public static ImmutableCacheStats addSnapshots(ImmutableCacheStats s1, ImmutableCacheStats s2) {
        return new ImmutableCacheStats(s1.hits + s2.hits, s1.misses + s2.misses, s1.evictions + s2.evictions, s1.sizeInBytes + s2.sizeInBytes, s1.items + s2.items);
    }

    public long getHits() {
        return this.hits;
    }

    public long getMisses() {
        return this.misses;
    }

    public long getEvictions() {
        return this.evictions;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public long getItems() {
        return this.items;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.hits);
        out.writeVLong(this.misses);
        out.writeVLong(this.evictions);
        out.writeVLong(this.sizeInBytes);
        out.writeVLong(this.items);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != ImmutableCacheStats.class) {
            return false;
        }
        ImmutableCacheStats other = (ImmutableCacheStats)o;
        return this.hits == other.hits && this.misses == other.misses && this.evictions == other.evictions && this.sizeInBytes == other.sizeInBytes && this.items == other.items;
    }

    public int hashCode() {
        return Objects.hash(this.hits, this.misses, this.evictions, this.sizeInBytes, this.items);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.humanReadableField("size_in_bytes", "size", new ByteSizeValue(this.sizeInBytes));
        builder.field("evictions", this.evictions);
        builder.field("hit_count", this.hits);
        builder.field("miss_count", this.misses);
        builder.field("item_count", this.items);
        return builder;
    }

    public static final class Fields {
        public static final String SIZE = "size";
        public static final String SIZE_IN_BYTES = "size_in_bytes";
        public static final String EVICTIONS = "evictions";
        public static final String HIT_COUNT = "hit_count";
        public static final String MISS_COUNT = "miss_count";
        public static final String ITEM_COUNT = "item_count";
    }
}

