/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.cache.store;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToLongBiFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.Cache;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.CacheBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.CacheType;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.ICache;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.ICacheKey;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.LoadAwareCacheLoader;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalNotification;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalReason;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.settings.CacheSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats.CacheStatsHolder;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats.DefaultCacheStatsHolder;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats.ImmutableCacheStatsHolder;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.stats.NoopCacheStatsHolder;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.store.builders.ICacheBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.store.config.CacheConfig;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.store.settings.OpenSearchOnHeapCacheSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.FeatureFlags;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;

public class OpenSearchOnHeapCache<K, V>
implements ICache<K, V>,
RemovalListener<ICacheKey<K>, V> {
    private final Cache<ICacheKey<K>, V> cache;
    private final CacheStatsHolder cacheStatsHolder;
    private final RemovalListener<ICacheKey<K>, V> removalListener;
    private final List<String> dimensionNames;
    private final ToLongBiFunction<ICacheKey<K>, V> weigher;
    private final boolean statsTrackingEnabled;

    public OpenSearchOnHeapCache(Builder<K, V> builder) {
        CacheBuilder cacheBuilder = CacheBuilder.builder().setMaximumWeight(builder.getMaxWeightInBytes()).weigher(builder.getWeigher()).removalListener(this);
        if (builder.getExpireAfterAcess() != null) {
            cacheBuilder.setExpireAfterAccess(builder.getExpireAfterAcess());
        }
        this.cache = cacheBuilder.build();
        this.dimensionNames = Objects.requireNonNull(builder.dimensionNames, "Dimension names can't be null");
        this.statsTrackingEnabled = builder.getStatsTrackingEnabled();
        this.cacheStatsHolder = this.statsTrackingEnabled ? new DefaultCacheStatsHolder(this.dimensionNames, "opensearch_onheap") : NoopCacheStatsHolder.getInstance();
        this.removalListener = builder.getRemovalListener();
        this.weigher = builder.getWeigher();
    }

    @Override
    public V get(ICacheKey<K> key) {
        V value = this.cache.get(key);
        if (value != null) {
            this.cacheStatsHolder.incrementHits(key.dimensions);
        } else {
            this.cacheStatsHolder.incrementMisses(key.dimensions);
        }
        return value;
    }

    @Override
    public void put(ICacheKey<K> key, V value) {
        this.cache.put(key, value);
        this.cacheStatsHolder.incrementItems(key.dimensions);
        this.cacheStatsHolder.incrementSizeInBytes(key.dimensions, this.weigher.applyAsLong(key, value));
    }

    @Override
    public V computeIfAbsent(ICacheKey<K> key, LoadAwareCacheLoader<ICacheKey<K>, V> loader) throws Exception {
        Object value = this.cache.computeIfAbsent(key, (K key1) -> loader.load(key));
        if (!loader.isLoaded()) {
            this.cacheStatsHolder.incrementHits(key.dimensions);
        } else {
            this.cacheStatsHolder.incrementMisses(key.dimensions);
            this.cacheStatsHolder.incrementItems(key.dimensions);
            this.cacheStatsHolder.incrementSizeInBytes(key.dimensions, this.cache.getWeigher().applyAsLong(key, value));
        }
        return (V)value;
    }

    @Override
    public void invalidate(ICacheKey<K> key) {
        if (key.getDropStatsForDimensions()) {
            this.cacheStatsHolder.removeDimensions(key.dimensions);
        }
        if (key.key != null) {
            this.cache.invalidate(key);
        }
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
        this.cacheStatsHolder.reset();
    }

    @Override
    public Iterable<ICacheKey<K>> keys() {
        return this.cache.keys();
    }

    @Override
    public long count() {
        return this.cache.count();
    }

    @Override
    public void refresh() {
        this.cache.refresh();
    }

    @Override
    public void close() {
    }

    @Override
    public ImmutableCacheStatsHolder stats(String[] levels) {
        return this.cacheStatsHolder.getImmutableCacheStatsHolder(levels);
    }

    @Override
    public void onRemoval(RemovalNotification<ICacheKey<K>, V> notification) {
        this.removalListener.onRemoval(notification);
        this.cacheStatsHolder.decrementItems(notification.getKey().dimensions);
        this.cacheStatsHolder.decrementSizeInBytes(notification.getKey().dimensions, this.cache.getWeigher().applyAsLong(notification.getKey(), notification.getValue()));
        if (RemovalReason.EVICTED.equals((Object)notification.getRemovalReason()) || RemovalReason.CAPACITY.equals((Object)notification.getRemovalReason())) {
            this.cacheStatsHolder.incrementEvictions(notification.getKey().dimensions);
        }
    }

    public static class Builder<K, V>
    extends ICacheBuilder<K, V> {
        private List<String> dimensionNames;

        public Builder<K, V> setDimensionNames(List<String> dimensionNames) {
            this.dimensionNames = dimensionNames;
            return this;
        }

        @Override
        public ICache<K, V> build() {
            return new OpenSearchOnHeapCache(this);
        }
    }

    public static class OpenSearchOnHeapCacheFactory
    implements ICache.Factory {
        public static final String NAME = "opensearch_onheap";

        @Override
        public <K, V> ICache<K, V> create(CacheConfig<K, V> config, CacheType cacheType, Map<String, ICache.Factory> cacheFactories) {
            Map<String, Setting<?>> settingList = OpenSearchOnHeapCacheSettings.getSettingListForCacheType(cacheType);
            Settings settings = config.getSettings();
            boolean statsTrackingEnabled = this.statsTrackingEnabled(config.getSettings(), config.getStatsTrackingEnabled());
            ICacheBuilder builder = new Builder().setDimensionNames(config.getDimensionNames()).setStatsTrackingEnabled(statsTrackingEnabled).setMaximumWeightInBytes(((ByteSizeValue)settingList.get("maximum_size_in_bytes").get(settings)).getBytes()).setExpireAfterAccess((TimeValue)settingList.get("expire_after_access").get(settings)).setWeigher(config.getWeigher()).setRemovalListener(config.getRemovalListener());
            Setting<String> cacheSettingForCacheType = CacheSettings.CACHE_TYPE_STORE_NAME.getConcreteSettingForNamespace(cacheType.getSettingPrefix());
            String storeName = cacheSettingForCacheType.get(settings);
            if (!FeatureFlags.PLUGGABLE_CACHE_SETTING.get(settings).booleanValue() || storeName == null || storeName.isBlank()) {
                builder.setMaximumWeightInBytes(config.getMaxSizeInBytes());
                builder.setExpireAfterAccess(config.getExpireAfterAccess());
            }
            return builder.build();
        }

        @Override
        public String getCacheName() {
            return NAME;
        }

        private boolean statsTrackingEnabled(Settings settings, boolean statsTrackingEnabledConfig) {
            return FeatureFlags.PLUGGABLE_CACHE_SETTING.get(settings) != false && statsTrackingEnabledConfig;
        }
    }
}

